<?php
AuthController::requireAuth();
$userId = AuthController::getUserId();
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="base-url" content="<?php echo BASE_URL; ?>">
    <meta name="user-id" content="<?php echo $userId; ?>">
    <title>Transações - Finance Manager</title>
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/assets/css/theme.css">
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/assets/css/layout.css">
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar">
        <div class="navbar-brand">
            <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <path d="M12 2v20M2 12h20M7 7h10v10H7z"/>
            </svg>
            Finance Manager
        </div>
        <button class="navbar-toggle">
            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <line x1="3" y1="6" x2="21" y2="6"></line>
                <line x1="3" y1="12" x2="21" y2="12"></line>
                <line x1="3" y1="18" x2="21" y2="18"></line>
            </svg>
        </button>
        <ul class="navbar-menu">
            <li><a href="<?php echo BASE_URL; ?>/dashboard">Dashboard</a></li>
            <li><a href="<?php echo BASE_URL; ?>/transactions" class="active">Transações</a></li>
            <li><a href="<?php echo BASE_URL; ?>/accounts">Contas</a></li>
            <li><a href="<?php echo BASE_URL; ?>/reports">Relatórios</a></li>
            <li><a href="<?php echo BASE_URL; ?>/settings">Configurações</a></li>
            <li><a href="<?php echo BASE_URL; ?>/auth/logout">Sair</a></li>
        </ul>
    </nav>

    <div style="display: flex;">
        <!-- Sidebar -->
        <aside class="sidebar">
            <ul class="sidebar-menu">
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/dashboard">
                        <i>📊</i>
                        Dashboard
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/transactions" class="active">
                        <i>💳</i>
                        Transações
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/accounts">
                        <i>🏦</i>
                        Contas
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/cards">
                        <i>💰</i>
                        Cartões
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/categories">
                        <i>🏷️</i>
                        Categorias
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/reports">
                        <i>📈</i>
                        Relatórios
                    </a>
                </li>
            </ul>
        </aside>

        <!-- Main Content -->
        <main class="main-content">
            <!-- Page Header -->
            <div class="page-header">
                <div>
                    <h1 class="page-title">Transações</h1>
                    <p style="color: var(--color-medium-gray); margin: 0;">
                        Gerencie suas receitas e despesas
                    </p>
                </div>
                <div class="page-actions">
                    <button class="btn btn-primary" data-modal-trigger="add-transaction-modal">
                        ➕ Nova Transação
                    </button>
                </div>
            </div>

            <!-- Filtros -->
            <div class="card" style="margin-bottom: 24px;">
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 16px;">
                    <div class="form-group">
                        <label for="filter-type">Tipo</label>
                        <select id="filter-type" name="type">
                            <option value="">Todos</option>
                            <option value="income">Receita</option>
                            <option value="expense">Despesa</option>
                            <option value="transfer">Transferência</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="filter-start-date">Data Inicial</label>
                        <input type="date" id="filter-start-date" name="start_date" value="<?php echo date('Y-m-01'); ?>">
                    </div>

                    <div class="form-group">
                        <label for="filter-end-date">Data Final</label>
                        <input type="date" id="filter-end-date" name="end_date" value="<?php echo date('Y-m-d'); ?>">
                    </div>

                    <div class="form-group" style="display: flex; align-items: flex-end;">
                        <button class="btn btn-primary" onclick="applyFilters()" style="width: 100%;">
                            Filtrar
                        </button>
                    </div>
                </div>
            </div>

            <!-- Lista de Transações -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Histórico de Transações</h3>
                </div>
                <div style="overflow-x: auto;">
                    <table>
                        <thead>
                            <tr>
                                <th>Data</th>
                                <th>Descrição</th>
                                <th>Categoria</th>
                                <th>Conta</th>
                                <th>Tipo</th>
                                <th>Valor</th>
                                <th>Status</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody id="transactions-table">
                            <tr>
                                <td colspan="8" style="text-align: center; padding: 40px;">
                                    <p style="color: var(--color-medium-gray);">Carregando transações...</p>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </main>
    </div>

    <!-- Modal de Nova Transação -->
    <div id="add-transaction-modal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h2 class="modal-title">Nova Transação</h2>
                <button class="modal-close">×</button>
            </div>
            <div class="modal-body">
                <form id="transaction-form" data-validate>
                    <div class="form-group">
                        <label for="trans-type">Tipo</label>
                        <select id="trans-type" name="type" required>
                            <option value="">Selecione o tipo</option>
                            <option value="income">Receita</option>
                            <option value="expense">Despesa</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="trans-description">Descrição</label>
                        <input type="text" id="trans-description" name="description" placeholder="Ex: Compra no supermercado" required>
                    </div>

                    <div class="form-group">
                        <label for="trans-amount">Valor</label>
                        <input type="number" id="trans-amount" name="amount" placeholder="0.00" step="0.01" min="0" required>
                    </div>

                    <div class="form-group">
                        <label for="trans-account">Conta</label>
                        <select id="trans-account" name="account_id" required>
                            <option value="">Selecione uma conta</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="trans-date">Data</label>
                        <input type="date" id="trans-date" name="transaction_date" value="<?php echo date('Y-m-d'); ?>" required>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button class="btn btn-outline" onclick="APP.closeModal('add-transaction-modal')">Cancelar</button>
                <button class="btn btn-primary" onclick="submitTransactionForm()">Registrar</button>
            </div>
        </div>
    </div>

    <script src="<?php echo BASE_URL; ?>/assets/js/app.js"></script>
    <script src="<?php echo BASE_URL; ?>/assets/js/transactions.js"></script>
</body>
</html>
