<?php
AuthController::requireAuth();
$userId = AuthController::getUserId();
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="base-url" content="<?php echo BASE_URL; ?>">
    <meta name="user-id" content="<?php echo $userId; ?>">
    <title>Tags - Finance Manager</title>
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/assets/css/theme.css">
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/assets/css/layout.css">
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar">
        <div class="navbar-brand">
            <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <path d="M12 2v20M2 12h20M7 7h10v10H7z"/>
            </svg>
            Finance Manager
        </div>
        <button class="navbar-toggle">
            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <line x1="3" y1="6" x2="21" y2="6"></line>
                <line x1="3" y1="12" x2="21" y2="12"></line>
                <line x1="3" y1="18" x2="21" y2="18"></line>
            </svg>
        </button>
        <ul class="navbar-menu">
            <li><a href="<?php echo BASE_URL; ?>/dashboard">Dashboard</a></li>
            <li><a href="<?php echo BASE_URL; ?>/transactions">Transações</a></li>
            <li><a href="<?php echo BASE_URL; ?>/accounts">Contas</a></li>
            <li><a href="<?php echo BASE_URL; ?>/reports">Relatórios</a></li>
            <li><a href="<?php echo BASE_URL; ?>/settings">Configurações</a></li>
            <li><a href="<?php echo BASE_URL; ?>/auth/logout">Sair</a></li>
        </ul>
    </nav>

    <div style="display: flex;">
        <!-- Sidebar -->
        <aside class="sidebar">
            <ul class="sidebar-menu">
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/dashboard">
                        <i>📊</i>
                        Dashboard
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/transactions">
                        <i>💳</i>
                        Transações
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/tags" class="active">
                        <i>🔖</i>
                        Tags
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/categories">
                        <i>🏷️</i>
                        Categorias
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/reports">
                        <i>📈</i>
                        Relatórios
                    </a>
                </li>
            </ul>
        </aside>

        <!-- Main Content -->
        <main class="main-content">
            <!-- Page Header -->
            <div class="page-header">
                <div>
                    <h1 class="page-title">Tags e Subtags</h1>
                    <p style="color: var(--color-medium-gray); margin: 0;">
                        Organize suas transações com tags personalizadas
                    </p>
                </div>
                <div class="page-actions">
                    <button class="btn btn-primary" data-modal-trigger="add-tag-modal">
                        ➕ Nova Tag
                    </button>
                </div>
            </div>

            <!-- Tags List -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Tags Principais</h3>
                </div>
                <div id="tags-list" style="padding: 16px;">
                    <p style="color: var(--color-medium-gray); text-align: center;">Carregando tags...</p>
                </div>
            </div>
        </main>
    </div>

    <!-- Modal de Nova Tag -->
    <div id="add-tag-modal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h2 class="modal-title">Nova Tag</h2>
                <button class="modal-close">×</button>
            </div>
            <div class="modal-body">
                <form id="tag-form" data-validate>
                    <div class="form-group">
                        <label for="tag-name">Nome da Tag</label>
                        <input type="text" id="tag-name" name="name" placeholder="Ex: Viagem, Projeto X..." required>
                    </div>

                    <div class="form-group">
                        <label for="tag-parent">Tag Principal (Opcional)</label>
                        <select id="tag-parent" name="parent_tag_id">
                            <option value="">Nenhuma (Tag Principal)</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="tag-description">Descrição</label>
                        <textarea id="tag-description" name="description" placeholder="Descrição da tag..." rows="3"></textarea>
                    </div>

                    <div class="form-group">
                        <label for="tag-color">Cor</label>
                        <input type="color" id="tag-color" name="color" value="#FFA500">
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button class="btn btn-outline" onclick="APP.closeModal('add-tag-modal')">Cancelar</button>
                <button class="btn btn-primary" onclick="submitTagForm()">Criar Tag</button>
            </div>
        </div>
    </div>

    <script src="<?php echo BASE_URL; ?>/assets/js/app.js"></script>
    <script src="<?php echo BASE_URL; ?>/assets/js/tags.js"></script>
</body>
</html>
