<?php
AuthController::requireAuth();
$userId = AuthController::getUserId();
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="base-url" content="<?php echo BASE_URL; ?>">
    <meta name="user-id" content="<?php echo $userId; ?>">
    <title>Relatórios - Finance Manager</title>
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/assets/css/theme.css">
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/assets/css/layout.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js@3.9.1/dist/chart.min.js"></script>
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar">
        <div class="navbar-brand">
            <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <path d="M12 2v20M2 12h20M7 7h10v10H7z"/>
            </svg>
            Finance Manager
        </div>
        <button class="navbar-toggle">
            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <line x1="3" y1="6" x2="21" y2="6"></line>
                <line x1="3" y1="12" x2="21" y2="12"></line>
                <line x1="3" y1="18" x2="21" y2="18"></line>
            </svg>
        </button>
        <ul class="navbar-menu">
            <li><a href="<?php echo BASE_URL; ?>/dashboard">Dashboard</a></li>
            <li><a href="<?php echo BASE_URL; ?>/transactions">Transações</a></li>
            <li><a href="<?php echo BASE_URL; ?>/reports" class="active">Relatórios</a></li>
            <li><a href="<?php echo BASE_URL; ?>/settings">Configurações</a></li>
            <li><a href="<?php echo BASE_URL; ?>/auth/logout">Sair</a></li>
        </ul>
    </nav>

    <div style="display: flex;">
        <!-- Sidebar -->
        <aside class="sidebar">
            <ul class="sidebar-menu">
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/dashboard">
                        <i>📊</i>
                        Dashboard
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/transactions">
                        <i>💳</i>
                        Transações
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/reports" class="active">
                        <i>📈</i>
                        Relatórios
                    </a>
                </li>
            </ul>
        </aside>

        <!-- Main Content -->
        <main class="main-content">
            <!-- Page Header -->
            <div class="page-header">
                <div>
                    <h1 class="page-title">Relatórios Financeiros</h1>
                    <p style="color: var(--color-medium-gray); margin: 0;">
                        Análise detalhada de suas finanças
                    </p>
                </div>
                <div class="page-actions">
                    <button class="btn btn-primary" onclick="Reports.exportPDF()">
                        📄 Exportar PDF
                    </button>
                </div>
            </div>

            <!-- Filtros -->
            <div class="card" style="margin-bottom: 24px;">
                <div class="card-header">
                    <h3 class="card-title">Filtros</h3>
                </div>
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 16px; padding: 16px;">
                    <div class="form-group">
                        <label for="filter-start-date">Data Inicial</label>
                        <input type="date" id="filter-start-date" value="<?php echo date('Y-m-01'); ?>">
                    </div>

                    <div class="form-group">
                        <label for="filter-end-date">Data Final</label>
                        <input type="date" id="filter-end-date" value="<?php echo date('Y-m-d'); ?>">
                    </div>

                    <div class="form-group">
                        <label for="filter-type">Tipo</label>
                        <select id="filter-type">
                            <option value="">Todos</option>
                            <option value="income">Receita</option>
                            <option value="expense">Despesa</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="filter-account">Conta</label>
                        <select id="filter-account">
                            <option value="">Todas</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="filter-category">Categoria</label>
                        <select id="filter-category">
                            <option value="">Todas</option>
                        </select>
                    </div>

                    <div class="form-group" style="display: flex; align-items: flex-end;">
                        <button class="btn btn-primary" onclick="Reports.applyFilters()" style="width: 100%;">
                            Aplicar Filtros
                        </button>
                    </div>
                </div>
            </div>

            <!-- Resumo -->
            <div class="dashboard-grid">
                <div class="stat-card balance">
                    <div class="stat-card-label">Total de Receitas</div>
                    <div class="stat-card-value" id="total-income">R$ 0,00</div>
                </div>

                <div class="stat-card expense">
                    <div class="stat-card-label">Total de Despesas</div>
                    <div class="stat-card-value" id="total-expense">R$ 0,00</div>
                </div>

                <div class="stat-card balance">
                    <div class="stat-card-label">Saldo</div>
                    <div class="stat-card-value" id="total-balance">R$ 0,00</div>
                </div>

                <div class="stat-card income">
                    <div class="stat-card-label">Total de Transações</div>
                    <div class="stat-card-value" id="total-transactions">0</div>
                </div>
            </div>

            <!-- Gráficos -->
            <div class="charts-grid">
                <div class="chart-card">
                    <h3 class="chart-title">Distribuição por Categoria</h3>
                    <div class="chart-container">
                        <canvas id="category-chart"></canvas>
                    </div>
                </div>

                <div class="chart-card">
                    <h3 class="chart-title">Distribuição por Conta</h3>
                    <div class="chart-container">
                        <canvas id="account-chart"></canvas>
                    </div>
                </div>
            </div>

            <!-- Tabela de Transações -->
            <div class="card" style="margin-top: 24px;">
                <div class="card-header">
                    <h3 class="card-title">Transações Detalhadas</h3>
                </div>
                <div style="overflow-x: auto;">
                    <table>
                        <thead>
                            <tr>
                                <th>Data</th>
                                <th>Descrição</th>
                                <th>Categoria</th>
                                <th>Conta</th>
                                <th>Tipo</th>
                                <th>Valor</th>
                                <th>Tags</th>
                            </tr>
                        </thead>
                        <tbody id="transactions-table">
                            <tr>
                                <td colspan="7" style="text-align: center; padding: 40px;">
                                    <p style="color: var(--color-medium-gray);">Carregando transações...</p>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </main>
    </div>

    <script src="<?php echo BASE_URL; ?>/assets/js/app.js"></script>
    <script src="<?php echo BASE_URL; ?>/assets/js/reports.js"></script>
</body>
</html>
