<?php
AuthController::requireAuth();
$userId = AuthController::getUserId();
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="base-url" content="<?php echo BASE_URL; ?>">
    <meta name="user-id" content="<?php echo $userId; ?>">
    <title>Open Banking - Finance Manager</title>
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/assets/css/theme.css">
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/assets/css/layout.css">
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar">
        <div class="navbar-brand">
            <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <path d="M12 2v20M2 12h20M7 7h10v10H7z"/>
            </svg>
            Finance Manager
        </div>
        <button class="navbar-toggle">
            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <line x1="3" y1="6" x2="21" y2="6"></line>
                <line x1="3" y1="12" x2="21" y2="12"></line>
                <line x1="3" y1="18" x2="21" y2="18"></line>
            </svg>
        </button>
        <ul class="navbar-menu">
            <li><a href="<?php echo BASE_URL; ?>/dashboard">Dashboard</a></li>
            <li><a href="<?php echo BASE_URL; ?>/accounts">Contas</a></li>
            <li><a href="<?php echo BASE_URL; ?>/settings">Configurações</a></li>
            <li><a href="<?php echo BASE_URL; ?>/auth/logout">Sair</a></li>
        </ul>
    </nav>

    <div style="display: flex;">
        <!-- Sidebar -->
        <aside class="sidebar">
            <ul class="sidebar-menu">
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/dashboard">
                        <i>📊</i>
                        Dashboard
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/accounts">
                        <i>🏦</i>
                        Contas
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/open-banking" class="active">
                        <i>🔗</i>
                        Open Banking
                    </a>
                </li>
            </ul>
        </aside>

        <!-- Main Content -->
        <main class="main-content">
            <!-- Page Header -->
            <div class="page-header">
                <div>
                    <h1 class="page-title">Integração Open Banking</h1>
                    <p style="color: var(--color-medium-gray); margin: 0;">
                        Conecte suas contas bancárias automaticamente
                    </p>
                </div>
                <div class="page-actions">
                    <button class="btn btn-primary" data-modal-trigger="connect-bank-modal">
                        🔗 Conectar Banco
                    </button>
                </div>
            </div>

            <!-- Info Card -->
            <div class="card" style="background-color: #f0f8ff; border-left: 4px solid var(--color-dark-navy); margin-bottom: 24px;">
                <div style="padding: 16px;">
                    <h4 style="margin: 0 0 8px 0; color: var(--color-dark-navy);">Como funciona?</h4>
                    <p style="margin: 0; color: var(--color-medium-gray); font-size: 14px;">
                        Conecte suas contas bancárias através do Open Banking para sincronizar automaticamente suas transações. 
                        Seus dados são criptografados e seguros.
                    </p>
                </div>
            </div>

            <!-- Conexões -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Contas Conectadas</h3>
                </div>
                <div id="connections-list" style="padding: 16px;">
                    <p style="color: var(--color-medium-gray); text-align: center;">Carregando conexões...</p>
                </div>
            </div>
        </main>
    </div>

    <!-- Modal de Conectar Banco -->
    <div id="connect-bank-modal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h2 class="modal-title">Conectar Banco</h2>
                <button class="modal-close">×</button>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label for="bank-select">Selecione seu banco</label>
                    <select id="bank-select" required>
                        <option value="">Escolha um banco</option>
                        <option value="001">Banco do Brasil</option>
                        <option value="033">Santander</option>
                        <option value="104">Caixa Econômica Federal</option>
                        <option value="237">Bradesco</option>
                        <option value="341">Itaú</option>
                        <option value="389">Banco Mercantil</option>
                        <option value="422">Banco Safra</option>
                        <option value="633">Banco Inter</option>
                        <option value="655">Banco Neon</option>
                        <option value="756">Banco Cooperativo</option>
                    </select>
                </div>
                <p style="color: var(--color-medium-gray); font-size: 12px; margin-top: 16px;">
                    Você será redirecionado para o seu banco para autorizar a conexão.
                </p>
            </div>
            <div class="modal-footer">
                <button class="btn btn-outline" onclick="APP.closeModal('connect-bank-modal')">Cancelar</button>
                <button class="btn btn-primary" onclick="OpenBanking.connectBank()">Conectar</button>
            </div>
        </div>
    </div>

    <script src="<?php echo BASE_URL; ?>/assets/js/app.js"></script>
    <script src="<?php echo BASE_URL; ?>/assets/js/open-banking.js"></script>
</body>
</html>
