<?php
// Se o usuário está autenticado, mostrar layout completo
$isAuthenticated = AuthController::isAuthenticated();
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="base-url" content="<?php echo BASE_URL; ?>">
    <title>Erro interno - Finance Manager</title>
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/assets/css/theme.css">
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/assets/css/layout.css">
</head>
<body>
    <?php if ($isAuthenticated): ?>
        <!-- Navbar -->
        <nav class="navbar">
            <div class="navbar-brand">
                <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M12 2v20M2 12h20M7 7h10v10H7z"/>
                </svg>
                Finance Manager
            </div>
            <button class="navbar-toggle">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <line x1="3" y1="6" x2="21" y2="6"></line>
                    <line x1="3" y1="12" x2="21" y2="12"></line>
                    <line x1="3" y1="18" x2="21" y2="18"></line>
                </svg>
            </button>
            <ul class="navbar-menu">
                <li><a href="<?php echo BASE_URL; ?>/dashboard">Dashboard</a></li>
                <li><a href="<?php echo BASE_URL; ?>/transactions">Transações</a></li>
                <li><a href="<?php echo BASE_URL; ?>/auth/logout">Sair</a></li>
            </ul>
        </nav>

        <div style="display: flex;">
            <!-- Sidebar -->
            <aside class="sidebar">
                <ul class="sidebar-menu">
                    <li class="sidebar-menu-item">
                        <a href="<?php echo BASE_URL; ?>/dashboard">
                            <i>📊</i>
                            Dashboard
                        </a>
                    </li>
                    <li class="sidebar-menu-item">
                        <a href="<?php echo BASE_URL; ?>/transactions">
                            <i>💳</i>
                            Transações
                        </a>
                    </li>
                </ul>
            </aside>

            <!-- Main Content -->
            <main class="main-content">
                <div style="text-align: center; padding: 60px 20px;">
                    <h1 style="font-size: 72px; margin: 0; color: var(--color-dark-red);">500</h1>
                    <h2 style="color: var(--color-dark-navy); margin-top: 20px;">Erro interno do servidor</h2>
                    <p style="color: var(--color-medium-gray); margin-bottom: 30px;">
                        Desculpe, ocorreu um erro interno. Nossa equipe foi notificada e está trabalhando para resolver.
                    </p>
                    <a href="<?php echo BASE_URL; ?>/dashboard" class="btn btn-primary btn-lg">
                        Voltar ao Dashboard
                    </a>
                </div>
            </main>
        </div>
    <?php else: ?>
        <!-- Página de erro para usuários não autenticados -->
        <div style="display: flex; align-items: center; justify-content: center; min-height: 100vh; background: linear-gradient(135deg, var(--color-military-green), var(--color-dark-navy)); padding: 20px;">
            <div style="text-align: center; background: white; padding: 60px; border-radius: 12px; box-shadow: 0 20px 25px rgba(0, 0, 0, 0.1);">
                <h1 style="font-size: 72px; margin: 0; color: var(--color-dark-red);">500</h1>
                <h2 style="color: var(--color-dark-navy); margin-top: 20px;">Erro interno do servidor</h2>
                <p style="color: var(--color-medium-gray); margin-bottom: 30px;">
                    Desculpe, ocorreu um erro interno. Nossa equipe foi notificada e está trabalhando para resolver.
                </p>
                <a href="<?php echo BASE_URL; ?>/auth/login" class="btn btn-primary btn-lg">
                    Voltar ao Login
                </a>
            </div>
        </div>
    <?php endif; ?>

    <script src="<?php echo BASE_URL; ?>/assets/js/app.js"></script>
</body>
</html>
