<?php
require_once __DIR__ . '/../../controllers/DashboardController.php';

$dashboardController = new DashboardController();
$dashboardDataJson = $dashboardController->getDashboardData();
$dashboardData = json_decode($dashboardDataJson, true);

if (!$dashboardData['success']) {
    header('Location: ' . BASE_URL . '/auth/login');
    exit;
}

$user = $dashboardData['user'];
$summary = $dashboardData['summary'];
$accounts = $dashboardData['accounts'];
$recentTransactions = $dashboardData['recent_transactions'];
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="base-url" content="<?php echo BASE_URL; ?>">
    <meta name="user-id" content="<?php echo $user['id']; ?>">
    <meta name="currency" content="<?php echo $user['currency']; ?>">
    <title>Dashboard - Finance Manager</title>
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/assets/css/theme.css">
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/assets/css/layout.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js@3.9.1/dist/chart.min.js"></script>
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar">
        <div class="navbar-brand">
            <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <path d="M12 2v20M2 12h20M7 7h10v10H7z"/>
            </svg>
            Finance Manager
        </div>
        <button class="navbar-toggle">
            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <line x1="3" y1="6" x2="21" y2="6"></line>
                <line x1="3" y1="12" x2="21" y2="12"></line>
                <line x1="3" y1="18" x2="21" y2="18"></line>
            </svg>
        </button>
        <ul class="navbar-menu">
            <li><a href="<?php echo BASE_URL; ?>/dashboard" class="active">Dashboard</a></li>
            <li><a href="<?php echo BASE_URL; ?>/transactions">Transações</a></li>
            <li><a href="<?php echo BASE_URL; ?>/accounts">Contas</a></li>
            <li><a href="<?php echo BASE_URL; ?>/reports">Relatórios</a></li>
            <li><a href="<?php echo BASE_URL; ?>/settings">Configurações</a></li>
            <li><a href="<?php echo BASE_URL; ?>/auth/logout">Sair</a></li>
        </ul>
    </nav>

    <div style="display: flex;">
        <!-- Sidebar -->
        <aside class="sidebar">
            <ul class="sidebar-menu">
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/dashboard" class="active">
                        <i>📊</i>
                        Dashboard
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/transactions">
                        <i>💳</i>
                        Transações
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/accounts">
                        <i>🏦</i>
                        Contas
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/cards">
                        <i>💰</i>
                        Cartões
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/categories">
                        <i>🏷️</i>
                        Categorias
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/tags">
                        <i>🔖</i>
                        Tags
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/goals">
                        <i>🎯</i>
                        Objetivos
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/plans">
                        <i>📋</i>
                        Planejamentos
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/reports">
                        <i>📈</i>
                        Relatórios
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/settings">
                        <i>⚙️</i>
                        Configurações
                    </a>
                </li>
            </ul>
        </aside>

        <!-- Main Content -->
        <main class="main-content">
            <!-- Page Header -->
            <div class="page-header">
                <div>
                    <h1 class="page-title">Bem-vindo, <?php echo htmlspecialchars($user['name']); ?>!</h1>
                    <p style="color: var(--color-medium-gray); margin: 0;">
                        Aqui está um resumo das suas finanças
                    </p>
                </div>
                <div class="page-actions">
                    <button class="btn btn-primary" data-modal-trigger="add-transaction-modal">
                        ➕ Nova Transação
                    </button>
                </div>
            </div>

            <!-- Stats Cards -->
            <div class="dashboard-grid">
                <div class="stat-card balance">
                    <div class="stat-card-label">Saldo Total</div>
                    <div class="stat-card-value" id="total-balance">
                        <?php echo APP::formatCurrency($summary['total_balance'], $user['currency']); ?>
                    </div>
                    <div class="stat-card-change">
                        <?php echo count($accounts); ?> conta(s) ativa(s)
                    </div>
                </div>

                <div class="stat-card income">
                    <div class="stat-card-label">Receitas (Este Mês)</div>
                    <div class="stat-card-value" id="total-income">
                        <?php echo APP::formatCurrency($summary['total_income'], $user['currency']); ?>
                    </div>
                    <div class="stat-card-change positive">
                        ↑ Entrada de recursos
                    </div>
                </div>

                <div class="stat-card expense">
                    <div class="stat-card-label">Despesas (Este Mês)</div>
                    <div class="stat-card-value" id="total-expense">
                        <?php echo APP::formatCurrency($summary['total_expense'], $user['currency']); ?>
                    </div>
                    <div class="stat-card-change negative">
                        ↓ Saída de recursos
                    </div>
                </div>

                <div class="stat-card balance">
                    <div class="stat-card-label">Saldo Disponível</div>
                    <div class="stat-card-value" id="available-balance">
                        <?php echo APP::formatCurrency($summary['available_balance'], $user['currency']); ?>
                    </div>
                    <div class="stat-card-change">
                        Mês: <?php echo date('M/Y', strtotime($summary['period']['start_date'])); ?>
                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="action-buttons">
                <button class="action-btn action-btn-income" data-modal-trigger="add-income-modal">
                    <div class="action-btn-icon">💵</div>
                    <div class="action-btn-label">Ganhei Dinheiro</div>
                </button>
                <button class="action-btn action-btn-expense" data-modal-trigger="add-expense-modal">
                    <div class="action-btn-icon">💸</div>
                    <div class="action-btn-label">Gastei Dinheiro</div>
                </button>
                <button class="action-btn" style="background-color: var(--color-dark-navy); color: white;">
                    <div class="action-btn-icon">🔄</div>
                    <div class="action-btn-label">Transferência</div>
                </button>
            </div>

            <!-- Charts -->
            <div class="charts-grid">
                <div class="chart-card">
                    <h3 class="chart-title">Receitas vs Despesas (Últimos 30 dias)</h3>
                    <div class="chart-container">
                        <canvas id="income-expense-chart"></canvas>
                    </div>
                </div>

                <div class="chart-card">
                    <h3 class="chart-title">Distribuição por Categoria</h3>
                    <div class="chart-container">
                        <canvas id="category-chart"></canvas>
                    </div>
                </div>
            </div>

            <!-- Recent Transactions -->
            <div class="transactions-container">
                <div class="transactions-header">
                    <h3 class="card-title">Transações Recentes</h3>
                    <a href="<?php echo BASE_URL; ?>/transactions" class="btn btn-outline btn-sm">
                        Ver Todas
                    </a>
                </div>
                <ul class="transactions-list">
                    <?php if (!empty($recentTransactions)): ?>
                        <?php foreach ($recentTransactions as $transaction): ?>
                            <li class="transaction-item">
                                <div class="transaction-info">
                                    <div class="transaction-icon" style="background-color: <?php echo $transaction['type'] === 'income' ? 'rgba(45, 80, 22, 0.2)' : 'rgba(139, 0, 0, 0.2)'; ?>">
                                        <?php echo $transaction['type'] === 'income' ? '📥' : '📤'; ?>
                                    </div>
                                    <div class="transaction-details">
                                        <h4><?php echo htmlspecialchars($transaction['description'] ?? $transaction['category_name'] ?? 'Transação'); ?></h4>
                                        <p><?php echo APP::formatDate($transaction['transaction_date']); ?> • <?php echo htmlspecialchars($transaction['account_name']); ?></p>
                                    </div>
                                </div>
                                <div class="transaction-amount <?php echo $transaction['type']; ?>">
                                    <?php echo ($transaction['type'] === 'income' ? '+' : '-') . APP::formatCurrency($transaction['amount'], $user['currency']); ?>
                                </div>
                            </li>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <li class="transaction-item">
                            <p style="margin: 0; color: var(--color-medium-gray); text-align: center; width: 100%;">
                                Nenhuma transação registrada ainda
                            </p>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        </main>
    </div>

    <!-- Modais -->
    <div id="add-income-modal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h2 class="modal-title">Registrar Receita</h2>
                <button class="modal-close">×</button>
            </div>
            <div class="modal-body">
                <form id="income-form" data-validate>
                    <div class="form-group">
                        <label for="income-description">Descrição</label>
                        <input type="text" id="income-description" name="description" placeholder="Ex: Salário, Freelance..." required>
                    </div>
                    <div class="form-group">
                        <label for="income-amount">Valor</label>
                        <input type="number" id="income-amount" name="amount" placeholder="0.00" step="0.01" min="0" required>
                    </div>
                    <div class="form-group">
                        <label for="income-account">Conta</label>
                        <select id="income-account" name="account_id" required>
                            <option value="">Selecione uma conta</option>
                            <?php foreach ($accounts as $account): ?>
                                <option value="<?php echo $account['id']; ?>"><?php echo htmlspecialchars($account['name']); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="income-date">Data</label>
                        <input type="date" id="income-date" name="transaction_date" value="<?php echo date('Y-m-d'); ?>" required>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button class="btn btn-outline" onclick="APP.closeModal('add-income-modal')">Cancelar</button>
                <button class="btn btn-primary" onclick="submitIncomeForm()">Registrar Receita</button>
            </div>
        </div>
    </div>

    <div id="add-expense-modal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h2 class="modal-title">Registrar Despesa</h2>
                <button class="modal-close">×</button>
            </div>
            <div class="modal-body">
                <form id="expense-form" data-validate>
                    <div class="form-group">
                        <label for="expense-description">Descrição</label>
                        <input type="text" id="expense-description" name="description" placeholder="Ex: Supermercado, Gasolina..." required>
                    </div>
                    <div class="form-group">
                        <label for="expense-amount">Valor</label>
                        <input type="number" id="expense-amount" name="amount" placeholder="0.00" step="0.01" min="0" required>
                    </div>
                    <div class="form-group">
                        <label for="expense-account">Conta</label>
                        <select id="expense-account" name="account_id" required>
                            <option value="">Selecione uma conta</option>
                            <?php foreach ($accounts as $account): ?>
                                <option value="<?php echo $account['id']; ?>"><?php echo htmlspecialchars($account['name']); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="expense-date">Data</label>
                        <input type="date" id="expense-date" name="transaction_date" value="<?php echo date('Y-m-d'); ?>" required>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button class="btn btn-outline" onclick="APP.closeModal('add-expense-modal')">Cancelar</button>
                <button class="btn btn-danger" onclick="submitExpenseForm()">Registrar Despesa</button>
            </div>
        </div>
    </div>

    <script src="<?php echo BASE_URL; ?>/assets/js/app.js"></script>
    <script src="<?php echo BASE_URL; ?>/assets/js/dashboard.js"></script>
</body>
</html>
