<?php
AuthController::requireAuth();
$userId = AuthController::getUserId();
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="base-url" content="<?php echo BASE_URL; ?>">
    <meta name="user-id" content="<?php echo $userId; ?>">
    <title>Categorias - Finance Manager</title>
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/assets/css/theme.css">
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/assets/css/layout.css">
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar">
        <div class="navbar-brand">
            <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <path d="M12 2v20M2 12h20M7 7h10v10H7z"/>
            </svg>
            Finance Manager
        </div>
        <button class="navbar-toggle">
            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <line x1="3" y1="6" x2="21" y2="6"></line>
                <line x1="3" y1="12" x2="21" y2="12"></line>
                <line x1="3" y1="18" x2="21" y2="18"></line>
            </svg>
        </button>
        <ul class="navbar-menu">
            <li><a href="<?php echo BASE_URL; ?>/dashboard">Dashboard</a></li>
            <li><a href="<?php echo BASE_URL; ?>/transactions">Transações</a></li>
            <li><a href="<?php echo BASE_URL; ?>/accounts">Contas</a></li>
            <li><a href="<?php echo BASE_URL; ?>/reports">Relatórios</a></li>
            <li><a href="<?php echo BASE_URL; ?>/settings">Configurações</a></li>
            <li><a href="<?php echo BASE_URL; ?>/auth/logout">Sair</a></li>
        </ul>
    </nav>

    <div style="display: flex;">
        <!-- Sidebar -->
        <aside class="sidebar">
            <ul class="sidebar-menu">
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/dashboard">
                        <i>📊</i>
                        Dashboard
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/transactions">
                        <i>💳</i>
                        Transações
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/categories" class="active">
                        <i>🏷️</i>
                        Categorias
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/tags">
                        <i>🔖</i>
                        Tags
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/reports">
                        <i>📈</i>
                        Relatórios
                    </a>
                </li>
            </ul>
        </aside>

        <!-- Main Content -->
        <main class="main-content">
            <!-- Page Header -->
            <div class="page-header">
                <div>
                    <h1 class="page-title">Categorias</h1>
                    <p style="color: var(--color-medium-gray); margin: 0;">
                        Organize suas transações por categorias
                    </p>
                </div>
                <div class="page-actions">
                    <button class="btn btn-primary" data-modal-trigger="add-category-modal">
                        ➕ Nova Categoria
                    </button>
                </div>
            </div>

            <!-- Filtro de Tipo -->
            <div class="card" style="margin-bottom: 24px;">
                <div class="form-group">
                    <label for="filter-type">Filtrar por Tipo</label>
                    <select id="filter-type" onchange="Categories.filterByType(this.value)">
                        <option value="">Todas</option>
                        <option value="income">Receitas</option>
                        <option value="expense">Despesas</option>
                    </select>
                </div>
            </div>

            <!-- Categorias Grid -->
            <div id="categories-grid" class="row">
                <p style="color: var(--color-medium-gray); text-align: center; width: 100%;">Carregando categorias...</p>
            </div>
        </main>
    </div>

    <!-- Modal de Nova Categoria -->
    <div id="add-category-modal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h2 class="modal-title">Nova Categoria</h2>
                <button class="modal-close">×</button>
            </div>
            <div class="modal-body">
                <form id="category-form" data-validate>
                    <div class="form-group">
                        <label for="category-name">Nome da Categoria</label>
                        <input type="text" id="category-name" name="name" placeholder="Ex: Alimentação, Transporte..." required>
                    </div>

                    <div class="form-group">
                        <label for="category-type">Tipo</label>
                        <select id="category-type" name="type" required>
                            <option value="">Selecione o tipo</option>
                            <option value="income">Receita</option>
                            <option value="expense">Despesa</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="category-description">Descrição</label>
                        <textarea id="category-description" name="description" placeholder="Descrição da categoria..." rows="3"></textarea>
                    </div>

                    <div class="form-group">
                        <label for="category-color">Cor</label>
                        <input type="color" id="category-color" name="color" value="#2D5016">
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button class="btn btn-outline" onclick="APP.closeModal('add-category-modal')">Cancelar</button>
                <button class="btn btn-primary" onclick="submitCategoryForm()">Criar Categoria</button>
            </div>
        </div>
    </div>

    <script src="<?php echo BASE_URL; ?>/assets/js/app.js"></script>
    <script src="<?php echo BASE_URL; ?>/assets/js/categories.js"></script>
</body>
</html>
