<?php
// Se o usuário já está autenticado, redirecionar para dashboard
if (AuthController::isAuthenticated()) {
    header('Location: ' . BASE_URL . '/dashboard');
    exit;
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="base-url" content="<?php echo BASE_URL; ?>">
    <title>Login - Finance Manager</title>
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/assets/css/theme.css">
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/assets/css/auth.css">
</head>
<body class="auth-page">
    <div class="auth-container">
        <div class="auth-card">
            <div class="auth-header">
                <h1>Finance Manager</h1>
                <p>Gerencie suas finanças com inteligência</p>
            </div>

            <!-- Abas de Login/Registro -->
            <div class="auth-tabs">
                <button class="auth-tab active" data-tab="login">Login</button>
                <button class="auth-tab" data-tab="register">Registrar</button>
            </div>

            <!-- Formulário de Login -->
            <div class="auth-tab-content active" id="login-tab">
                <form id="login-form" class="auth-form" data-validate>
                    <div class="form-group">
                        <label for="login-email">Email</label>
                        <input 
                            type="email" 
                            id="login-email" 
                            name="email" 
                            placeholder="seu@email.com"
                            required
                        >
                    </div>

                    <div class="form-group">
                        <label for="login-password">Senha</label>
                        <input 
                            type="password" 
                            id="login-password" 
                            name="password" 
                            placeholder="Sua senha"
                            required
                        >
                    </div>

                    <div class="form-group">
                        <label class="checkbox-label">
                            <input type="checkbox" name="remember">
                            Lembrar-me
                        </label>
                    </div>

                    <button type="submit" class="btn btn-primary btn-lg" style="width: 100%;">
                        Entrar
                    </button>

                    <div class="auth-divider">
                        <span>ou</span>
                    </div>

                    <!-- Opções de Login Social -->
                    <div class="social-login">
                        <button type="button" class="btn-social google" data-provider="google">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M22.56 12.25c0-.78-.07-1.53-.2-2.25H12v4.26h5.92c-.26 1.37-1.04 2.53-2.21 3.31v2.77h3.57c2.08-1.92 3.28-4.74 3.28-8.09z"/>
                                <path d="M12 23c2.97 0 5.46-.98 7.28-2.66l-3.57-2.77c-.98.66-2.23 1.06-3.71 1.06-2.86 0-5.29-1.93-6.16-4.53H2.18v2.84C3.99 20.53 7.7 23 12 23z"/>
                                <path d="M5.84 14.09c-.22-.66-.35-1.36-.35-2.09s.13-1.43.35-2.09V7.07H2.18C1.43 8.55 1 10.22 1 12s.43 3.45 1.18 4.93l2.85-2.22.81-.62z"/>
                                <path d="M12 5.38c1.62 0 3.06.56 4.21 1.64l3.15-3.15C17.45 2.09 14.97 1 12 1 7.7 1 3.99 3.47 2.18 7.07l3.66 2.84c.87-2.6 3.3-4.53 6.16-4.53z"/>
                            </svg>
                            Google
                        </button>

                        <button type="button" class="btn-social apple" data-provider="apple">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M17.05 13.5c-.91 2.18-.41 3.96 1.09 5.05 1.08.71 2.08.48 2.86-.13.78-.61 1.23-1.42 1.23-2.39 0-1.06-.43-2.06-1.23-2.87-.8-.81-1.8-1.23-2.95-1.23-1.15 0-2.15.42-2.95 1.23-.8.81-1.23 1.81-1.23 2.87 0 1.06.43 2.06 1.23 2.87.8.81 1.8 1.23 2.95 1.23 1.15 0 2.15-.42 2.95-1.23.8-.81 1.23-1.81 1.23-2.87 0-1.06-.43-2.06-1.23-2.87-.8-.81-1.8-1.23-2.95-1.23"/>
                            </svg>
                            Apple
                        </button>
                    </div>

                    <p class="auth-footer-text">
                        <a href="#forgot-password">Esqueceu sua senha?</a>
                    </p>
                </form>
            </div>

            <!-- Formulário de Registro -->
            <div class="auth-tab-content" id="register-tab">
                <form id="register-form" class="auth-form" data-validate>
                    <div class="form-group">
                        <label for="register-first-name">Nome</label>
                        <input 
                            type="text" 
                            id="register-first-name" 
                            name="first_name" 
                            placeholder="Seu nome"
                            required
                        >
                    </div>

                    <div class="form-group">
                        <label for="register-last-name">Sobrenome</label>
                        <input 
                            type="text" 
                            id="register-last-name" 
                            name="last_name" 
                            placeholder="Seu sobrenome"
                        >
                    </div>

                    <div class="form-group">
                        <label for="register-email">Email</label>
                        <input 
                            type="email" 
                            id="register-email" 
                            name="email" 
                            placeholder="seu@email.com"
                            required
                        >
                    </div>

                    <div class="form-group">
                        <label for="register-password">Senha</label>
                        <input 
                            type="password" 
                            id="register-password" 
                            name="password" 
                            placeholder="Mínimo 8 caracteres"
                            minlength="8"
                            required
                        >
                    </div>

                    <div class="form-group">
                        <label for="register-password-confirm">Confirmar Senha</label>
                        <input 
                            type="password" 
                            id="register-password-confirm" 
                            name="password_confirm" 
                            placeholder="Confirme sua senha"
                            minlength="8"
                            required
                        >
                    </div>

                    <div class="form-group">
                        <label class="checkbox-label">
                            <input type="checkbox" name="terms" required>
                            Concordo com os <a href="#">Termos de Serviço</a>
                        </label>
                    </div>

                    <button type="submit" class="btn btn-primary btn-lg" style="width: 100%;">
                        Criar Conta
                    </button>

                    <div class="auth-divider">
                        <span>ou</span>
                    </div>

                    <!-- Opções de Registro Social -->
                    <div class="social-login">
                        <button type="button" class="btn-social google" data-provider="google">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M22.56 12.25c0-.78-.07-1.53-.2-2.25H12v4.26h5.92c-.26 1.37-1.04 2.53-2.21 3.31v2.77h3.57c2.08-1.92 3.28-4.74 3.28-8.09z"/>
                                <path d="M12 23c2.97 0 5.46-.98 7.28-2.66l-3.57-2.77c-.98.66-2.23 1.06-3.71 1.06-2.86 0-5.29-1.93-6.16-4.53H2.18v2.84C3.99 20.53 7.7 23 12 23z"/>
                                <path d="M5.84 14.09c-.22-.66-.35-1.36-.35-2.09s.13-1.43.35-2.09V7.07H2.18C1.43 8.55 1 10.22 1 12s.43 3.45 1.18 4.93l2.85-2.22.81-.62z"/>
                                <path d="M12 5.38c1.62 0 3.06.56 4.21 1.64l3.15-3.15C17.45 2.09 14.97 1 12 1 7.7 1 3.99 3.47 2.18 7.07l3.66 2.84c.87-2.6 3.3-4.53 6.16-4.53z"/>
                            </svg>
                            Google
                        </button>

                        <button type="button" class="btn-social apple" data-provider="apple">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M17.05 13.5c-.91 2.18-.41 3.96 1.09 5.05 1.08.71 2.08.48 2.86-.13.78-.61 1.23-1.42 1.23-2.39 0-1.06-.43-2.06-1.23-2.87-.8-.81-1.8-1.23-2.95-1.23-1.15 0-2.15.42-2.95 1.23-.8.81-1.23 1.81-1.23 2.87 0 1.06.43 2.06 1.23 2.87.8.81 1.8 1.23 2.95 1.23 1.15 0 2.15-.42 2.95-1.23.8-.81 1.23-1.81 1.23-2.87 0-1.06-.43-2.06-1.23-2.87-.8-.81-1.8-1.23-2.95-1.23"/>
                            </svg>
                            Apple
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="<?php echo BASE_URL; ?>/assets/js/app.js"></script>
    <script src="<?php echo BASE_URL; ?>/assets/js/auth.js"></script>
</body>
</html>
