<?php
AuthController::requireAuth();
$userId = AuthController::getUserId();
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="base-url" content="<?php echo BASE_URL; ?>">
    <meta name="user-id" content="<?php echo $userId; ?>">
    <title>Contas - Finance Manager</title>
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/assets/css/theme.css">
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/assets/css/layout.css">
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar">
        <div class="navbar-brand">
            <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <path d="M12 2v20M2 12h20M7 7h10v10H7z"/>
            </svg>
            Finance Manager
        </div>
        <button class="navbar-toggle">
            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <line x1="3" y1="6" x2="21" y2="6"></line>
                <line x1="3" y1="12" x2="21" y2="12"></line>
                <line x1="3" y1="18" x2="21" y2="18"></line>
            </svg>
        </button>
        <ul class="navbar-menu">
            <li><a href="<?php echo BASE_URL; ?>/dashboard">Dashboard</a></li>
            <li><a href="<?php echo BASE_URL; ?>/transactions">Transações</a></li>
            <li><a href="<?php echo BASE_URL; ?>/accounts" class="active">Contas</a></li>
            <li><a href="<?php echo BASE_URL; ?>/reports">Relatórios</a></li>
            <li><a href="<?php echo BASE_URL; ?>/settings">Configurações</a></li>
            <li><a href="<?php echo BASE_URL; ?>/auth/logout">Sair</a></li>
        </ul>
    </nav>

    <div style="display: flex;">
        <!-- Sidebar -->
        <aside class="sidebar">
            <ul class="sidebar-menu">
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/dashboard">
                        <i>📊</i>
                        Dashboard
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/transactions">
                        <i>💳</i>
                        Transações
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/accounts" class="active">
                        <i>🏦</i>
                        Contas
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/cards">
                        <i>💰</i>
                        Cartões
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/categories">
                        <i>🏷️</i>
                        Categorias
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo BASE_URL; ?>/reports">
                        <i>📈</i>
                        Relatórios
                    </a>
                </li>
            </ul>
        </aside>

        <!-- Main Content -->
        <main class="main-content">
            <!-- Page Header -->
            <div class="page-header">
                <div>
                    <h1 class="page-title">Contas Bancárias</h1>
                    <p style="color: var(--color-medium-gray); margin: 0;">
                        Gerencie suas contas bancárias
                    </p>
                </div>
                <div class="page-actions">
                    <button class="btn btn-primary" data-modal-trigger="add-account-modal">
                        ➕ Nova Conta
                    </button>
                </div>
            </div>

            <!-- Contas Grid -->
            <div id="accounts-grid" class="row" style="margin-bottom: 24px;">
                <p style="color: var(--color-medium-gray); text-align: center; width: 100%;">Carregando contas...</p>
            </div>

            <!-- Resumo de Saldo -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Resumo de Saldo</h3>
                </div>
                <div style="padding: 16px;">
                    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 16px;">
                        <div>
                            <p style="color: var(--color-medium-gray); margin: 0 0 8px 0; font-size: 12px;">Saldo Total</p>
                            <p style="font-size: 24px; font-weight: 700; color: var(--color-military-green); margin: 0;" id="total-balance">
                                R$ 0,00
                            </p>
                        </div>
                        <div>
                            <p style="color: var(--color-medium-gray); margin: 0 0 8px 0; font-size: 12px;">Contas Ativas</p>
                            <p style="font-size: 24px; font-weight: 700; color: var(--color-dark-navy); margin: 0;" id="active-accounts">
                                0
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <!-- Modal de Nova Conta -->
    <div id="add-account-modal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h2 class="modal-title">Nova Conta</h2>
                <button class="modal-close">×</button>
            </div>
            <div class="modal-body">
                <form id="account-form" data-validate>
                    <div class="form-group">
                        <label for="account-name">Nome da Conta</label>
                        <input type="text" id="account-name" name="name" placeholder="Ex: Conta Corrente Banco X" required>
                    </div>

                    <div class="form-group">
                        <label for="account-type">Tipo de Conta</label>
                        <select id="account-type" name="account_type" required>
                            <option value="">Selecione o tipo</option>
                            <option value="checking">Conta Corrente</option>
                            <option value="savings">Poupança</option>
                            <option value="investment">Investimento</option>
                            <option value="credit">Crédito</option>
                            <option value="other">Outro</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="account-bank">Banco</label>
                        <input type="text" id="account-bank" name="bank_name" placeholder="Ex: Banco do Brasil">
                    </div>

                    <div class="form-group">
                        <label for="account-balance">Saldo Inicial</label>
                        <input type="number" id="account-balance" name="balance" placeholder="0.00" step="0.01" min="0">
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button class="btn btn-outline" onclick="APP.closeModal('add-account-modal')">Cancelar</button>
                <button class="btn btn-primary" onclick="submitAccountForm()">Criar Conta</button>
            </div>
        </div>
    </div>

    <script src="<?php echo BASE_URL; ?>/assets/js/app.js"></script>
    <script src="<?php echo BASE_URL; ?>/assets/js/accounts.js"></script>
</body>
</html>
