<?php
/**
 * Gerador de PDF
 */

require_once __DIR__ . '/../../vendor/autoload.php';

use TCPDF;

class PDFGenerator {
    private $pdf;

    public function __construct() {
        $this->pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        
        // Configurar documento
        $this->pdf->SetCreator('Finance Manager');
        $this->pdf->SetAuthor('Finance Manager');
        $this->pdf->SetTitle('Relatório Financeiro');
        $this->pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        
        // Margens
        $this->pdf->SetMargins(15, 15, 15);
        $this->pdf->SetAutoPageBreak(TRUE, 15);
        
        // Fonte
        $this->pdf->SetFont('helvetica', '', 10);
    }

    /**
     * Gerar PDF a partir de HTML
     */
    public function generate($html, $filename = 'documento.pdf') {
        $this->pdf->AddPage();
        $this->pdf->writeHTML($html, true, false, true, false, '');
        
        // Enviar para download
        $this->pdf->Output($filename, 'D');
    }

    /**
     * Salvar PDF em arquivo
     */
    public function save($html, $filepath) {
        $this->pdf->AddPage();
        $this->pdf->writeHTML($html, true, false, true, false, '');
        
        // Salvar arquivo
        $this->pdf->Output($filepath, 'F');
        
        return $filepath;
    }

    /**
     * Obter conteúdo PDF como string
     */
    public function getContent($html) {
        $this->pdf->AddPage();
        $this->pdf->writeHTML($html, true, false, true, false, '');
        
        return $this->pdf->Output('', 'S');
    }
}
?>
