<?php
/**
 * Finance Manager - Arquivo Principal
 * Ponto de entrada da aplicação
 */

// Incluir configurações
require_once __DIR__ . '/../config/config.php';

// Obter a rota solicitada
$request_uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$base_path = '/financemanager';
$route = str_replace($base_path, '', $request_uri);
$route = trim($route, '/');

// Se a rota estiver vazia, redirecionar para dashboard
if (empty($route)) {
    $route = 'dashboard';
}

// Dividir a rota em partes
$route_parts = explode('/', $route);
$controller = $route_parts[0] ?? 'dashboard';
$action = $route_parts[1] ?? 'index';
$params = array_slice($route_parts, 2);

// Verificar autenticação para rotas protegidas
$public_routes = ['auth', 'api'];
if (!in_array($controller, $public_routes) && !AuthController::isAuthenticated()) {
    header('Location: ' . BASE_URL . '/auth/login');
    exit;
}

// Rotear para o controlador apropriado
try {
    switch ($controller) {
        case 'auth':
            require_once __DIR__ . '/../src/controllers/AuthController.php';
            $authController = new AuthController();
            
            if ($action === 'register') {
                echo $authController->register();
            } elseif ($action === 'login') {
                echo $authController->login();
            } elseif ($action === 'logout') {
                echo $authController->logout();
            } elseif ($action === 'google-callback') {
                echo $authController->googleCallback();
            } elseif ($action === 'apple-callback') {
                echo $authController->appleCallback();
            } else {
                // Mostrar página de login/registro
                require_once __DIR__ . '/../src/views/auth/login.php';
            }
            break;

        case 'api':
            // Rotas da API
            header('Content-Type: application/json');
            
            if ($action === 'auth' && isset($route_parts[2])) {
                require_once __DIR__ . '/../src/controllers/AuthController.php';
                $authController = new AuthController();
                
                $method = $route_parts[2];
                if ($method === 'current-user') {
                    echo $authController->getCurrentUser();
                } elseif ($method === 'logout') {
                    echo $authController->logout();
                }
            }
            break;

        case 'dashboard':
            AuthController::requireAuth();
            require_once __DIR__ . '/../src/views/dashboard/index.php';
            break;

        case 'transactions':
            AuthController::requireAuth();
            require_once __DIR__ . '/../src/views/transactions/index.php';
            break;

        case 'accounts':
            AuthController::requireAuth();
            require_once __DIR__ . '/../src/views/accounts/index.php';
            break;

        case 'cards':
            AuthController::requireAuth();
            require_once __DIR__ . '/../src/views/cards/index.php';
            break;

        case 'categories':
            AuthController::requireAuth();
            require_once __DIR__ . '/../src/views/categories/index.php';
            break;

        case 'tags':
            AuthController::requireAuth();
            require_once __DIR__ . '/../src/views/tags/index.php';
            break;

        case 'goals':
            AuthController::requireAuth();
            require_once __DIR__ . '/../src/views/goals/index.php';
            break;

        case 'plans':
            AuthController::requireAuth();
            require_once __DIR__ . '/../src/views/plans/index.php';
            break;

        case 'reports':
            AuthController::requireAuth();
            require_once __DIR__ . '/../src/views/reports/index.php';
            break;

        case 'settings':
            AuthController::requireAuth();
            require_once __DIR__ . '/../src/views/settings/index.php';
            break;

        default:
            http_response_code(404);
            require_once __DIR__ . '/../src/views/errors/404.php';
    }
} catch (Exception $e) {
    logError('Erro ao rotear requisição: ' . $e->getMessage(), [
        'route' => $route,
        'controller' => $controller,
        'action' => $action
    ]);
    
    http_response_code(500);
    require_once __DIR__ . '/../src/views/errors/500.php';
}
?>
