<?php
/**
 * Finance Manager - Roteador de API
 */

// Incluir configurações
require_once __DIR__ . '/../config/config.php';

// Definir header JSON
header('Content-Type: application/json; charset=utf-8');

// Obter a rota solicitada
$request_uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$base_path = '/financemanager/api';
$route = str_replace($base_path, '', $request_uri);
$route = trim($route, '/');

// Dividir a rota em partes
$route_parts = explode('/', $route);
$resource = $route_parts[0] ?? null;
$action = $route_parts[1] ?? null;

// Rotear para o controlador apropriado
try {
    switch ($resource) {
        case 'auth':
            require_once __DIR__ . '/../src/controllers/AuthController.php';
            $controller = new AuthController();
            
            if ($action === 'register') {
                echo $controller->register();
            } elseif ($action === 'login') {
                echo $controller->login();
            } elseif ($action === 'logout') {
                echo $controller->logout();
            } elseif ($action === 'current-user') {
                echo $controller->getCurrentUser();
            } elseif ($action === 'update-profile') {
                echo $controller->updateProfile();
            } else {
                http_response_code(404);
                echo json_encode(['error' => 'Endpoint não encontrado']);
            }
            break;

        case 'dashboard':
            require_once __DIR__ . '/../src/controllers/DashboardController.php';
            $controller = new DashboardController();
            
            if ($action === 'data') {
                echo $controller->getDashboardData();
            } elseif ($action === 'chart-data') {
                echo $controller->getChartData();
            } else {
                http_response_code(404);
                echo json_encode(['error' => 'Endpoint não encontrado']);
            }
            break;

        case 'transactions':
            require_once __DIR__ . '/../src/controllers/TransactionController.php';
            $controller = new TransactionController();
            
            if ($action === 'create') {
                echo $controller->create();
            } elseif ($action === 'list') {
                echo $controller->getList();
            } elseif ($action === 'get') {
                echo $controller->getById();
            } elseif ($action === 'update') {
                echo $controller->update();
            } elseif ($action === 'delete') {
                echo $controller->delete();
            } else {
                http_response_code(404);
                echo json_encode(['error' => 'Endpoint não encontrado']);
            }
            break;

        case 'accounts':
            require_once __DIR__ . '/../src/controllers/AccountController.php';
            $controller = new AccountController();
            
            if ($action === 'create') {
                echo $controller->create();
            } elseif ($action === 'list') {
                echo $controller->getList();
            } elseif ($action === 'get') {
                echo $controller->getById();
            } elseif ($action === 'update') {
                echo $controller->update();
            } elseif ($action === 'delete') {
                echo $controller->delete();
            } elseif ($action === 'total-balance') {
                echo $controller->getTotalBalance();
            } else {
                http_response_code(404);
                echo json_encode(['error' => 'Endpoint não encontrado']);
            }
            break;

        case 'cards':
            require_once __DIR__ . '/../src/controllers/CreditCardController.php';
            $controller = new CreditCardController();
            
            if ($action === 'create') {
                echo $controller->create();
            } elseif ($action === 'list') {
                echo $controller->getList();
            } elseif ($action === 'get') {
                echo $controller->getById();
            } elseif ($action === 'update') {
                echo $controller->update();
            } elseif ($action === 'delete') {
                echo $controller->delete();
            } elseif ($action === 'total-limit') {
                echo $controller->getTotalCreditLimit();
            } elseif ($action === 'total-balance') {
                echo $controller->getTotalBalance();
            } else {
                http_response_code(404);
                echo json_encode(['error' => 'Endpoint não encontrado']);
            }
            break;

        case 'categories':
            require_once __DIR__ . '/../src/controllers/CategoryController.php';
            $controller = new CategoryController();
            
            if ($action === 'create') {
                echo $controller->create();
            } elseif ($action === 'list') {
                echo $controller->getList();
            } elseif ($action === 'get') {
                echo $controller->getById();
            } elseif ($action === 'update') {
                echo $controller->update();
            } elseif ($action === 'delete') {
                echo $controller->delete();
            } else {
                http_response_code(404);
                echo json_encode(['error' => 'Endpoint não encontrado']);
            }
            break;

        case 'tags':
            require_once __DIR__ . '/../src/controllers/TagController.php';
            $controller = new TagController();
            
            if ($action === 'create') {
                echo $controller->create();
            } elseif ($action === 'list') {
                echo $controller->getList();
            } elseif ($action === 'get') {
                echo $controller->getById();
            } elseif ($action === 'update') {
                echo $controller->update();
            } elseif ($action === 'delete') {
                echo $controller->delete();
            } elseif ($action === 'add-to-transaction') {
                echo $controller->addToTransaction();
            } elseif ($action === 'remove-from-transaction') {
                echo $controller->removeFromTransaction();
            } elseif ($action === 'transaction-tags') {
                echo $controller->getTransactionTags();
            } else {
                http_response_code(404);
                echo json_encode(['error' => 'Endpoint não encontrado']);
            }
            break;

        case 'reports':
            require_once __DIR__ . '/../src/controllers/ReportController.php';
            $controller = new ReportController();
            
            if ($action === 'get') {
                echo $controller->getReport();
            } elseif ($action === 'summary-by-period') {
                echo $controller->getSummaryByPeriod();
            } elseif ($action === 'summary-by-category') {
                echo $controller->getSummaryByCategory();
            } elseif ($action === 'summary-by-account') {
                echo $controller->getSummaryByAccount();
            } elseif ($action === 'summary-by-tag') {
                echo $controller->getSummaryByTag();
            } elseif ($action === 'export-pdf') {
                echo $controller->exportPDF();
            } else {
                http_response_code(404);
                echo json_encode(['error' => 'Endpoint não encontrado']);
            }
            break;

        case 'open-banking':
            require_once __DIR__ . '/../src/controllers/OpenBankingController.php';
            $controller = new OpenBankingController();
            
            if ($action === 'connections') {
                echo $controller->getConnections();
            } elseif ($action === 'create') {
                echo $controller->createConnection();
            } elseif ($action === 'sync') {
                echo $controller->syncTransactions();
            } elseif ($action === 'sync-status') {
                echo $controller->getSyncStatus();
            } elseif ($action === 'delete') {
                echo $controller->deleteConnection();
            } elseif ($action === 'auth-url') {
                echo $controller->getAuthorizationURL();
            } else {
                http_response_code(404);
                echo json_encode(['error' => 'Endpoint não encontrado']);
            }
            break;

        default:
            http_response_code(404);
            echo json_encode(['error' => 'Recurso não encontrado']);
    }
} catch (Exception $e) {
    logError('Erro ao processar requisição de API: ' . $e->getMessage(), [
        'route' => $route,
        'resource' => $resource,
        'action' => $action
    ]);
    
    http_response_code(500);
    echo json_encode(['error' => 'Erro interno do servidor']);
}
?>
