<?php
/**
 * Configuração do Banco de Dados
 * Finance Manager SaaS
 */

// Definir constantes de ambiente
define('DB_HOST', getenv('DB_HOST') ?: 'localhost');
define('DB_USER', getenv('DB_USER') ?: 'root');
define('DB_PASS', getenv('DB_PASS') ?: '');
define('DB_NAME', getenv('DB_NAME') ?: 'finance_manager');
define('DB_PORT', getenv('DB_PORT') ?: 3306);

// Classe para conexão com banco de dados
class Database {
    private static $connection = null;

    public static function connect() {
        if (self::$connection === null) {
            try {
                self::$connection = new mysqli(
                    DB_HOST,
                    DB_USER,
                    DB_PASS,
                    DB_NAME,
                    DB_PORT
                );

                if (self::$connection->connect_error) {
                    throw new Exception("Erro de conexão: " . self::$connection->connect_error);
                }

                // Definir charset UTF-8
                self::$connection->set_charset("utf8mb4");
            } catch (Exception $e) {
                die("Erro ao conectar ao banco de dados: " . $e->getMessage());
            }
        }

        return self::$connection;
    }

    public static function getInstance() {
        return self::connect();
    }

    public static function close() {
        if (self::$connection !== null) {
            self::$connection->close();
            self::$connection = null;
        }
    }
}

// Função auxiliar para executar queries
function executeQuery($sql, $params = []) {
    $db = Database::getInstance();
    
    if (!empty($params)) {
        $stmt = $db->prepare($sql);
        if (!$stmt) {
            throw new Exception("Erro ao preparar query: " . $db->error);
        }
        
        // Bind parameters
        $types = '';
        foreach ($params as $param) {
            if (is_int($param)) {
                $types .= 'i';
            } elseif (is_float($param)) {
                $types .= 'd';
            } else {
                $types .= 's';
            }
        }
        
        $stmt->bind_param($types, ...$params);
        $stmt->execute();
        
        return $stmt;
    } else {
        return $db->query($sql);
    }
}

// Função para obter um resultado
function fetchOne($result) {
    if ($result instanceof mysqli_stmt) {
        return $result->get_result()->fetch_assoc();
    }
    return $result->fetch_assoc();
}

// Função para obter todos os resultados
function fetchAll($result) {
    if ($result instanceof mysqli_stmt) {
        return $result->get_result()->fetch_all(MYSQLI_ASSOC);
    }
    return $result->fetch_all(MYSQLI_ASSOC);
}
?>
