<?php
/**
 * Configuração Geral da Aplicação
 * Finance Manager SaaS
 */

session_start();

// URLs e caminhos
define('BASE_URL', getenv('BASE_URL') ?: 'http://localhost/financemanager');
define('APP_NAME', 'Finance Manager');
define('APP_VERSION', '1.0.0');

// Configurações de segurança
define('JWT_SECRET', getenv('JWT_SECRET') ?: 'sua_chave_secreta_aqui_mude_em_producao');
define('SESSION_TIMEOUT', 3600); // 1 hora
define('MAX_LOGIN_ATTEMPTS', 5);
define('LOCKOUT_TIME', 900); // 15 minutos

// Configurações de OAuth
define('GOOGLE_CLIENT_ID', getenv('GOOGLE_CLIENT_ID') ?: '');
define('GOOGLE_CLIENT_SECRET', getenv('GOOGLE_CLIENT_SECRET') ?: '');
define('GOOGLE_REDIRECT_URI', BASE_URL . '/auth/google-callback');

define('APPLE_TEAM_ID', getenv('APPLE_TEAM_ID') ?: '');
define('APPLE_CLIENT_ID', getenv('APPLE_CLIENT_ID') ?: '');
define('APPLE_KEY_ID', getenv('APPLE_KEY_ID') ?: '');

// Configurações de email
define('MAIL_HOST', getenv('MAIL_HOST') ?: 'smtp.gmail.com');
define('MAIL_PORT', getenv('MAIL_PORT') ?: 587);
define('MAIL_USER', getenv('MAIL_USER') ?: '');
define('MAIL_PASS', getenv('MAIL_PASS') ?: '');
define('MAIL_FROM', getenv('MAIL_FROM') ?: 'noreply@financemanager.com');

// Configurações de upload
define('UPLOAD_DIR', __DIR__ . '/../public/uploads/');
define('MAX_UPLOAD_SIZE', 5 * 1024 * 1024); // 5MB
define('ALLOWED_FILE_TYPES', ['pdf', 'jpg', 'jpeg', 'png', 'gif']);

// Configurações de paginação
define('ITEMS_PER_PAGE', 20);

// Timezone
date_default_timezone_set('America/Sao_Paulo');

// Incluir arquivo de banco de dados
require_once __DIR__ . '/database.php';

// Função para obter configuração
function getConfig($key, $default = null) {
    $config = [
        'app_name' => APP_NAME,
        'app_version' => APP_VERSION,
        'base_url' => BASE_URL,
    ];
    
    return $config[$key] ?? $default;
}

// Função para log de erros
function logError($message, $context = []) {
    $logFile = __DIR__ . '/../logs/error.log';
    if (!is_dir(dirname($logFile))) {
        mkdir(dirname($logFile), 0755, true);
    }
    
    $timestamp = date('Y-m-d H:i:s');
    $contextStr = !empty($context) ? json_encode($context) : '';
    $logMessage = "[$timestamp] $message $contextStr\n";
    
    file_put_contents($logFile, $logMessage, FILE_APPEND);
}

// Tratamento de erros
set_error_handler(function($errno, $errstr, $errfile, $errline) {
    logError("PHP Error: $errstr", [
        'file' => $errfile,
        'line' => $errline,
        'errno' => $errno
    ]);
});

// Tratamento de exceções não capturadas
set_exception_handler(function($exception) {
    logError("Exception: " . $exception->getMessage(), [
        'file' => $exception->getFile(),
        'line' => $exception->getLine(),
        'trace' => $exception->getTraceAsString()
    ]);
    
    header('Content-Type: application/json');
    http_response_code(500);
    echo json_encode(['error' => 'Erro interno do servidor']);
});
?>
