# Finance Manager - Gerenciador Financeiro SaaS

Um gerenciador financeiro completo e responsivo desenvolvido com PHP, MySQL, CSS e JavaScript. Ideal para gerenciar finanças pessoais com funcionalidades avançadas de categorização, relatórios e integração com bancos.

## 🎯 Características Principais

- ✅ **Autenticação Social**: Login com Google, Apple e Email
- ✅ **Dashboard Inteligente**: Resumo de saldo, gráficos rápidos e botões de ação
- ✅ **Gestão de Transações**: Registro de receitas e despesas
- ✅ **Contas e Cartões**: Cadastro e gerenciamento de contas bancárias e cartões de crédito
- ✅ **Categorias Personalizadas**: Organize suas transações por categorias
- ✅ **Tags e Subtags**: Sistema flexível de etiquetagem
- ✅ **Objetivos Financeiros**: Defina e acompanhe seus objetivos
- ✅ **Planejamentos Ilimitados**: Crie múltiplos planos financeiros
- ✅ **Relatórios Avançados**: Filtros completos e exportação em PDF
- ✅ **Integração Open Banking**: Conecte suas contas bancárias automaticamente
- ✅ **Design Responsivo**: Funciona perfeitamente em desktop, tablet e mobile
- ✅ **Tema Profissional**: Paleta de cores verde militar, cinza, vermelho, azul marinho e amarelo

## 📋 Requisitos

- PHP 7.4 ou superior
- MySQL 5.7 ou superior
- Apache com mod_rewrite ativado
- Extensões PHP: mysqli, json, gd

## 🚀 Instalação

### 1. Clonar o Repositório

```bash
git clone https://github.com/seu-usuario/financemanager.git
cd financemanager
```

### 2. Configurar Banco de Dados

```bash
# Criar banco de dados
mysql -u root -p < database/schema.sql
```

### 3. Configurar Variáveis de Ambiente

Crie um arquivo `.env` na raiz do projeto:

```env
# Banco de Dados
DB_HOST=localhost
DB_USER=root
DB_PASS=sua_senha
DB_NAME=finance_manager
DB_PORT=3306

# Aplicação
BASE_URL=http://localhost/financemanager
APP_NAME=Finance Manager
JWT_SECRET=sua_chave_secreta_muito_segura

# OAuth Google
GOOGLE_CLIENT_ID=seu_client_id
GOOGLE_CLIENT_SECRET=seu_client_secret

# OAuth Apple
APPLE_TEAM_ID=seu_team_id
APPLE_CLIENT_ID=seu_client_id
APPLE_KEY_ID=seu_key_id

# Email
MAIL_HOST=smtp.gmail.com
MAIL_PORT=587
MAIL_USER=seu_email@gmail.com
MAIL_PASS=sua_senha_app
MAIL_FROM=noreply@financemanager.com
```

### 4. Configurar Permissões

```bash
# Dar permissão de escrita aos diretórios necessários
chmod -R 755 public/
chmod -R 755 src/
chmod -R 755 logs/
chmod -R 755 public/uploads/
```

### 5. Acessar a Aplicação

Acesse `http://localhost/financemanager` no seu navegador.

## 📁 Estrutura do Projeto

```
financemanager/
├── config/                 # Configurações da aplicação
│   ├── config.php         # Configurações gerais
│   └── database.php       # Conexão com banco de dados
├── database/              # Scripts SQL
│   └── schema.sql         # Schema do banco de dados
├── public/                # Arquivos públicos (raiz do servidor web)
│   ├── index.php          # Arquivo principal
│   ├── .htaccess          # Configuração Apache
│   ├── uploads/           # Diretório de uploads
│   └── assets/            # Arquivos estáticos
│       ├── css/           # Folhas de estilo
│       ├── js/            # Scripts JavaScript
│       └── images/        # Imagens
├── src/                   # Código-fonte da aplicação
│   ├── controllers/       # Controladores
│   ├── models/            # Modelos de dados
│   └── views/             # Visualizações (templates)
├── logs/                  # Arquivos de log
├── vendor/                # Dependências (Composer)
└── README.md              # Este arquivo
```

## 🎨 Paleta de Cores

- **Verde Militar**: `#2D5016`
- **Cinza Claro**: `#E8E8E8`
- **Vermelho Escuro**: `#8B0000`
- **Azul Marinho Escuro**: `#1A3A52`
- **Amarelo Alaranjado**: `#FFA500`

## 🔐 Segurança

- Senhas criptografadas com bcrypt
- Proteção contra CSRF
- Validação de entrada em todos os formulários
- Headers de segurança configurados
- Proteção contra SQL Injection
- Rate limiting para tentativas de login

## 📱 Responsividade

A aplicação é totalmente responsiva e funciona em:

- **Desktop**: Resolução completa com sidebar
- **Tablet**: Interface adaptada com menu colapsável
- **Mobile**: Layout otimizado com navegação touch-friendly

## 🔌 Integração com Open Banking

Para integrar com APIs de Open Banking:

1. Registre-se em plataformas como:
   - [Plaid](https://plaid.com/)
   - [Yapstone](https://www.yapstone.com/)
   - [Open Banking Brasil](https://www.bcb.gov.br/estabilidadefinanceira/openbanking)

2. Configure as credenciais no arquivo `.env`

3. Implemente os endpoints de integração em `src/controllers/BankIntegrationController.php`

## 📊 Funcionalidades Futuras

- [ ] Integração com APIs de bancos reais
- [ ] Notificações em tempo real
- [ ] Análise preditiva de gastos
- [ ] Sincronização automática de transações
- [ ] Aplicativo mobile nativo
- [ ] Suporte a múltiplas moedas
- [ ] Compartilhamento de orçamentos

## 🐛 Reportar Bugs

Se encontrar algum bug, abra uma issue no repositório com:

- Descrição do problema
- Passos para reproduzir
- Screenshots (se aplicável)
- Versão do navegador/SO

## 📄 Licença

Este projeto está licenciado sob a MIT License - veja o arquivo LICENSE para detalhes.

## 👨‍💻 Autor

Desenvolvido com ❤️ para simplificar a gestão financeira pessoal.

## 🤝 Contribuindo

Contribuições são bem-vindas! Por favor:

1. Faça um Fork do projeto
2. Crie uma branch para sua feature (`git checkout -b feature/AmazingFeature`)
3. Commit suas mudanças (`git commit -m 'Add some AmazingFeature'`)
4. Push para a branch (`git push origin feature/AmazingFeature`)
5. Abra um Pull Request

## 📞 Suporte

Para suporte, envie um email para support@financemanager.com ou abra uma issue no repositório.

---

**Versão**: 1.0.0  
**Última atualização**: Janeiro 2026
