# 📸 Manual Visual de Instalação - Finance Manager

**Domínio**: jtisuporte.com.br  
**Guia passo a passo com descrições visuais**

---

## 🎯 Visão Geral

Este manual mostra **exatamente onde clicar** e **o que alterar** para instalar o Finance Manager no cPanel.

---

## 📋 Passo 1: Criar Banco de Dados no cPanel

### 1.1 Acessar MySQL Databases

**O que você verá:**

```
┌─────────────────────────────────────────────────┐
│ cPanel - Home                                   │
├─────────────────────────────────────────────────┤
│                                                 │
│  [🔍 Search]                                    │
│                                                 │
│  DATABASES                                      │
│  ┌──────────────┐  ┌──────────────┐           │
│  │  MySQL®      │  │  phpMyAdmin  │           │
│  │  Databases   │  │              │           │
│  └──────────────┘  └──────────────┘           │
│                                                 │
└─────────────────────────────────────────────────┘
```

**Ação**: Clique em **"MySQL® Databases"**

---

### 1.2 Criar Novo Banco de Dados

**O que você verá:**

```
┌─────────────────────────────────────────────────┐
│ MySQL® Databases                                │
├─────────────────────────────────────────────────┤
│                                                 │
│ Create New Database                             │
│                                                 │
│ New Database:                                   │
│ ┌─────────────────────────────────────────┐    │
│ │ financemanager                          │    │
│ └─────────────────────────────────────────┘    │
│                                                 │
│ [Create Database]                               │
│                                                 │
└─────────────────────────────────────────────────┘
```

**Ações:**
1. Digite: `financemanager` no campo "New Database"
2. Clique em **"Create Database"**

**Resultado esperado:**
```
✅ Database "financemanager" created successfully
```

---

### 1.3 Criar Usuário do Banco

**O que você verá:**

```
┌─────────────────────────────────────────────────┐
│ MySQL Users                                     │
├─────────────────────────────────────────────────┤
│                                                 │
│ Username:                                       │
│ ┌─────────────────────────────────────────┐    │
│ │ financemanager                          │    │
│ └─────────────────────────────────────────┘    │
│                                                 │
│ Password:                                       │
│ ┌─────────────────────────────────────────┐    │
│ │ ••••••••••••                            │    │
│ └─────────────────────────────────────────┘    │
│                                                 │
│ Password (Again):                               │
│ ┌─────────────────────────────────────────┐    │
│ │ ••••••••••••                            │    │
│ └─────────────────────────────────────────┘    │
│                                                 │
│ [Create User]                                   │
│                                                 │
└─────────────────────────────────────────────────┘
```

**Ações:**
1. Username: `financemanager`
2. Password: Digite uma senha forte (ex: `Senha@123!`)
3. Password (Again): Repita a senha
4. Clique em **"Create User"**

**⚠️ IMPORTANTE: Anote a senha em local seguro!**

---

### 1.4 Adicionar Usuário ao Banco

**O que você verá:**

```
┌─────────────────────────────────────────────────┐
│ Add User To Database                            │
├─────────────────────────────────────────────────┤
│                                                 │
│ User:                                           │
│ ┌─────────────────────────────────────────┐    │
│ │ financemanager                       ▼ │    │
│ └─────────────────────────────────────────┘    │
│                                                 │
│ Database:                                       │
│ ┌─────────────────────────────────────────┐    │
│ │ financemanager                       ▼ │    │
│ └─────────────────────────────────────────┘    │
│                                                 │
│ [Add]                                           │
│                                                 │
└─────────────────────────────────────────────────┘
```

**Ações:**
1. Selecione o usuário: `financemanager`
2. Selecione o banco: `financemanager`
3. Clique em **"Add"**

---

### 1.5 Definir Privilégios

**O que você verá:**

```
┌─────────────────────────────────────────────────┐
│ Manage User Privileges                          │
├─────────────────────────────────────────────────┤
│                                                 │
│ ☑ ALL PRIVILEGES                                │
│                                                 │
│ ☐ ALTER         ☐ CREATE        ☐ DELETE       │
│ ☐ DROP          ☐ INDEX         ☐ INSERT       │
│ ☐ SELECT        ☐ UPDATE        ☐ REFERENCES   │
│                                                 │
│ [Make Changes]                                  │
│                                                 │
└─────────────────────────────────────────────────┘
```

**Ações:**
1. Marque: ☑ **"ALL PRIVILEGES"**
2. Clique em **"Make Changes"**

**Resultado esperado:**
```
✅ User privileges updated successfully
```

---

## 📤 Passo 2: Upload dos Arquivos

### 2.1 Acessar File Manager

**O que você verá:**

```
┌─────────────────────────────────────────────────┐
│ cPanel - Home                                   │
├─────────────────────────────────────────────────┤
│                                                 │
│  FILES                                          │
│  ┌──────────────┐  ┌──────────────┐           │
│  │  File        │  │  FTP         │           │
│  │  Manager     │  │  Accounts    │           │
│  └──────────────┘  └──────────────┘           │
│                                                 │
└─────────────────────────────────────────────────┘
```

**Ação**: Clique em **"File Manager"**

---

### 2.2 Navegar até public_html

**O que você verá:**

```
┌─────────────────────────────────────────────────┐
│ File Manager                                    │
├─────────────┬───────────────────────────────────┤
│             │                                   │
│ 📁 home     │  Name          Size      Modified│
│  📁 ubuntu  │  ────────────────────────────────│
│   📂 public_html                                │
│    📁 cgi-bin                                   │
│    📄 index.html                                │
│    📄 .htaccess                                 │
│                                                 │
└─────────────┴───────────────────────────────────┘
```

**Ação**: Clique em **"public_html"** para abrir

---

### 2.3 Upload do Arquivo ZIP

**O que você verá:**

```
┌─────────────────────────────────────────────────┐
│ File Manager - public_html                      │
├─────────────────────────────────────────────────┤
│                                                 │
│ [Upload] [New File] [New Folder] [Copy] [Move] │
│                                                 │
└─────────────────────────────────────────────────┘
```

**Ações:**
1. Clique em **"Upload"** (ícone de seta para cima)
2. Clique em **"Select File"**
3. Selecione: `financemanager.zip`
4. Aguarde upload completar (barra de progresso)

**Resultado esperado:**
```
✅ Upload complete: financemanager.zip (116 KB)
```

---

### 2.4 Extrair Arquivo ZIP

**O que você verá:**

```
┌─────────────────────────────────────────────────┐
│ File Manager - public_html                      │
├─────────────────────────────────────────────────┤
│                                                 │
│  Name                    Size      Type         │
│  ───────────────────────────────────────────   │
│  📦 financemanager.zip   116 KB   ZIP Archive  │
│                                                 │
└─────────────────────────────────────────────────┘
```

**Ações:**
1. Clique direito em `financemanager.zip`
2. Selecione **"Extract"**
3. Confirme a extração
4. Aguarde conclusão

**Resultado esperado:**
```
✅ Extraction complete
   📁 financemanager/ created
```

---

### 2.5 Verificar Estrutura

**O que você verá após extração:**

```
┌─────────────────────────────────────────────────┐
│ File Manager - public_html                      │
├─────────────────────────────────────────────────┤
│                                                 │
│  📁 financemanager/                             │
│    📁 public/                                   │
│    📁 src/                                      │
│    📁 database/                                 │
│    📁 config/                                   │
│    📁 logs/                                     │
│    📁 uploads/                                  │
│    📄 .env                                      │
│    📄 install.php                               │
│    📄 README.md                                 │
│                                                 │
└─────────────────────────────────────────────────┘
```

**✅ Estrutura correta!**

---

## ⚙️ Passo 3: Instalação Automática

### 3.1 Acessar Instalador

**No navegador, digite:**
```
https://jtisuporte.com.br/financemanager/install.php
```

**O que você verá:**

```
┌─────────────────────────────────────────────────┐
│                                                 │
│              🚀 Finance Manager                 │
│           Instalação e Configuração             │
│                                                 │
│  ━━━━━━━━━━  ━━━━━━━━━━  ━━━━━━━━━━           │
│   Step 1      Step 2      Step 3               │
│                                                 │
│  Passo 1: Configuração do Banco de Dados       │
│                                                 │
│  ℹ️ Informações Necessárias                     │
│  Você precisará das credenciais do seu banco   │
│  de dados MySQL.                                │
│                                                 │
│  URL da Aplicação                               │
│  ┌─────────────────────────────────────────┐   │
│  │ https://jtisuporte.com.br               │   │
│  └─────────────────────────────────────────┘   │
│                                                 │
│  Host do Banco de Dados                         │
│  ┌─────────────────────────────────────────┐   │
│  │ localhost                               │   │
│  └─────────────────────────────────────────┘   │
│                                                 │
│  Porta do Banco de Dados                        │
│  ┌─────────────────────────────────────────┐   │
│  │ 3306                                    │   │
│  └─────────────────────────────────────────┘   │
│                                                 │
│  Nome do Banco de Dados                         │
│  ┌─────────────────────────────────────────┐   │
│  │ financemanager                          │   │
│  └─────────────────────────────────────────┘   │
│                                                 │
│  Usuário do Banco de Dados                      │
│  ┌─────────────────────────────────────────┐   │
│  │                                         │   │
│  └─────────────────────────────────────────┘   │
│                                                 │
│  Senha do Banco de Dados                        │
│  ┌─────────────────────────────────────────┐   │
│  │                                         │   │
│  └─────────────────────────────────────────┘   │
│                                                 │
│            [Continuar →]                        │
│                                                 │
└─────────────────────────────────────────────────┘
```

---

### 3.2 Preencher Formulário

**Preencha os campos:**

| Campo | Valor | Onde encontrar |
|-------|-------|----------------|
| URL da Aplicação | `https://jtisuporte.com.br` | Seu domínio |
| Host do Banco | `localhost` | Padrão cPanel |
| Porta do Banco | `3306` | Padrão MySQL |
| Nome do Banco | `financemanager` | Criado no Passo 1.2 |
| Usuário do Banco | `financemanager` | Criado no Passo 1.3 |
| Senha do Banco | `Senha@123!` | Criada no Passo 1.3 |

**Ação**: Clique em **"Continuar →"**

---

### 3.3 Confirmar Instalação

**O que você verá:**

```
┌─────────────────────────────────────────────────┐
│                                                 │
│              🚀 Finance Manager                 │
│           Instalação e Configuração             │
│                                                 │
│  ━━━━━━━━━━  ━━━━━━━━━━  ━━━━━━━━━━           │
│   Step 1      Step 2      Step 3               │
│                                                 │
│  Passo 2: Criar Banco de Dados                 │
│                                                 │
│  ⚙️ Processando                                 │
│  Clique em "Instalar" para criar o banco de    │
│  dados e importar as tabelas.                   │
│                                                 │
│            [Instalar →]                         │
│                                                 │
└─────────────────────────────────────────────────┘
```

**Ação**: Clique em **"Instalar →"**

---

### 3.4 Instalação Concluída

**O que você verá:**

```
┌─────────────────────────────────────────────────┐
│                                                 │
│                    ✅                           │
│                                                 │
│          Instalação Concluída!                  │
│                                                 │
│  Finance Manager foi instalado com sucesso em   │
│  sua hospedagem.                                │
│                                                 │
│  📋 Próximos Passos:                            │
│                                                 │
│  1. Delete este arquivo (install.php)          │
│  2. Acesse https://jtisuporte.com.br            │
│  3. Clique em "Registrar" para criar sua conta │
│  4. Configure OAuth (opcional)                  │
│  5. Configure Open Banking (opcional)           │
│                                                 │
│  ⚠️ Importante:                                 │
│  Após a instalação, delete o arquivo            │
│  install.php da raiz do projeto por questões    │
│  de segurança.                                  │
│                                                 │
│       [Acessar Finance Manager →]               │
│                                                 │
└─────────────────────────────────────────────────┘
```

**Ação**: Clique em **"Acessar Finance Manager →"**

---

## 🔧 Passo 4: Configuração Manual do .env (Alternativa)

### 4.1 Abrir Editor de Arquivo

**No File Manager:**

```
┌─────────────────────────────────────────────────┐
│ File Manager - financemanager/                  │
├─────────────────────────────────────────────────┤
│                                                 │
│  Name            Size      Type                 │
│  ───────────────────────────────────────────   │
│  📄 .env         2 KB      ENV File            │
│                                                 │
│  [Right Click] → Edit                           │
│                                                 │
└─────────────────────────────────────────────────┘
```

**Ações:**
1. Clique direito em `.env`
2. Selecione **"Edit"**

---

### 4.2 Editor de Texto

**O que você verá:**

```
┌─────────────────────────────────────────────────┐
│ Edit File: .env                          [Save] │
├─────────────────────────────────────────────────┤
│ 1  ; Finance Manager - Configuração             │
│ 2                                                │
│ 3  ; Banco de Dados                             │
│ 4  DB_HOST=localhost                            │
│ 5  DB_PORT=3306                                 │
│ 6  DB_NAME=financemanager                       │
│ 7  DB_USER=seu_usuario                          │
│ 8  DB_PASSWORD=sua_senha                        │
│ 9                                                │
│10  ; Aplicação                                  │
│11  APP_NAME=Finance Manager                     │
│12  APP_URL=http://localhost/financemanager      │
│13  APP_ENV=production                           │
│14  APP_DEBUG=false                              │
│                                                 │
└─────────────────────────────────────────────────┘
```

---

### 4.3 Alterações Necessárias

**ANTES:**
```ini
DB_HOST=localhost
DB_PORT=3306
DB_NAME=financemanager
DB_USER=seu_usuario          ← ALTERAR
DB_PASSWORD=sua_senha        ← ALTERAR
```

**DEPOIS:**
```ini
DB_HOST=localhost
DB_PORT=3306
DB_NAME=financemanager
DB_USER=financemanager       ← ALTERADO
DB_PASSWORD=Senha@123!       ← ALTERADO
```

---

**ANTES:**
```ini
APP_URL=http://localhost/financemanager  ← ALTERAR
```

**DEPOIS:**
```ini
APP_URL=https://jtisuporte.com.br/financemanager  ← ALTERADO
```

---

### 4.4 Salvar Arquivo

**Ações:**
1. Pressione **Ctrl+S** ou clique em **"Save"**
2. Feche o editor

**Resultado esperado:**
```
✅ File saved successfully
```

---

## 📊 Passo 5: Importar Banco via phpMyAdmin

### 5.1 Acessar phpMyAdmin

**No cPanel:**

```
┌─────────────────────────────────────────────────┐
│ cPanel - Home                                   │
├─────────────────────────────────────────────────┤
│                                                 │
│  DATABASES                                      │
│  ┌──────────────┐  ┌──────────────┐           │
│  │  MySQL®      │  │  phpMyAdmin  │ ← CLICAR  │
│  │  Databases   │  │              │           │
│  └──────────────┘  └──────────────┘           │
│                                                 │
└─────────────────────────────────────────────────┘
```

**Ação**: Clique em **"phpMyAdmin"**

---

### 5.2 Selecionar Banco de Dados

**O que você verá:**

```
┌─────────────────────────────────────────────────┐
│ phpMyAdmin                                      │
├───────────┬─────────────────────────────────────┤
│           │                                     │
│ 🗄️ Databases                                    │
│  📁 information_schema                          │
│  📁 mysql                                       │
│  📂 financemanager  ← CLICAR                    │
│                                                 │
└───────────┴─────────────────────────────────────┘
```

**Ação**: Clique em **"financemanager"**

---

### 5.3 Importar Schema

**O que você verá:**

```
┌─────────────────────────────────────────────────┐
│ phpMyAdmin - financemanager                     │
├─────────────────────────────────────────────────┤
│                                                 │
│ [Structure] [SQL] [Search] [Import] [Export]   │
│                           ^^^^^^^^              │
└─────────────────────────────────────────────────┘
```

**Ação**: Clique em **"Import"**

---

**Tela de Import:**

```
┌─────────────────────────────────────────────────┐
│ Import                                          │
├─────────────────────────────────────────────────┤
│                                                 │
│ File to import:                                 │
│                                                 │
│ ┌─────────────────────────────────────────┐    │
│ │ schema.sql                              │    │
│ └─────────────────────────────────────────┘    │
│                                                 │
│ [Choose File]                                   │
│                                                 │
│ Format: SQL ▼                                   │
│                                                 │
│            [Go]                                 │
│                                                 │
└─────────────────────────────────────────────────┘
```

**Ações:**
1. Clique em **"Choose File"**
2. Navegue até: `financemanager/database/schema.sql`
3. Selecione o arquivo
4. Clique em **"Go"**

**Resultado esperado:**
```
✅ Import has been successfully finished
   14 queries executed
```

---

## ✅ Passo 6: Verificação Final

### 6.1 Acessar Aplicação

**No navegador, digite:**
```
https://jtisuporte.com.br/financemanager/
```

**O que você deve ver:**

```
┌─────────────────────────────────────────────────┐
│                                                 │
│           💰 Finance Manager                    │
│                                                 │
│  ┌─────────────────────────────────────────┐   │
│  │                                         │   │
│  │  Email                                  │   │
│  │  ┌───────────────────────────────────┐ │   │
│  │  │                                   │ │   │
│  │  └───────────────────────────────────┘ │   │
│  │                                         │   │
│  │  Senha                                  │   │
│  │  ┌───────────────────────────────────┐ │   │
│  │  │                                   │ │   │
│  │  └───────────────────────────────────┘ │   │
│  │                                         │   │
│  │        [Entrar]                         │   │
│  │                                         │   │
│  │  ───────── ou ─────────                │   │
│  │                                         │   │
│  │  [🔵 Entrar com Google]                │   │
│  │  [⚫ Entrar com Apple]                  │   │
│  │                                         │   │
│  │  Não tem conta? [Registrar]            │   │
│  │                                         │   │
│  └─────────────────────────────────────────┘   │
│                                                 │
└─────────────────────────────────────────────────┘
```

**✅ Sucesso! A aplicação está funcionando!**

---

### 6.2 Criar Primeira Conta

**Ações:**
1. Clique em **"Registrar"**
2. Preencha:
   - Nome: Seu nome
   - Email: seu@email.com
   - Senha: Mínimo 8 caracteres
3. Clique em **"Criar Conta"**

**Você será redirecionado para o Dashboard:**

```
┌─────────────────────────────────────────────────┐
│ Finance Manager                    [👤 Perfil]  │
├─────────────────────────────────────────────────┤
│                                                 │
│  💰 Dashboard                                   │
│                                                 │
│  ┌─────────┐ ┌─────────┐ ┌─────────┐          │
│  │ Saldo   │ │ Receitas│ │ Despesas│          │
│  │ R$ 0,00 │ │ R$ 0,00 │ │ R$ 0,00 │          │
│  └─────────┘ └─────────┘ └─────────┘          │
│                                                 │
│  [💵 Ganhei Dinheiro] [💸 Gastei Dinheiro]     │
│                                                 │
│  📊 Gráficos                                    │
│  ┌─────────────────────────────────────────┐   │
│  │                                         │   │
│  │     (Gráfico de Receitas vs Despesas)  │   │
│  │                                         │   │
│  └─────────────────────────────────────────┘   │
│                                                 │
└─────────────────────────────────────────────────┘
```

**✅ Instalação concluída com sucesso!**

---

## 🎉 Parabéns!

Você instalou o Finance Manager com sucesso!

### Próximos Passos:

1. ✅ **Delete install.php** (segurança)
2. ✅ Adicione sua primeira transação
3. ✅ Configure OAuth (opcional)
4. ✅ Configure Open Banking (opcional)
5. ✅ Explore os relatórios

---

**Dúvidas?** Consulte:
- `MANUAL_INSTALACAO_CPANEL.md` - Manual completo
- `GUIA_RAPIDO_CONFIGURACAO.md` - Configurações rápidas
- `API_DOCUMENTATION.md` - Documentação da API

---

**Versão**: 1.0.0  
**Última atualização**: Janeiro 2024
