# 📖 Manual de Instalação - Finance Manager no cPanel

**Domínio**: jtisuporte.com.br  
**Versão**: 1.0.0  
**Data**: Janeiro 2024

---

## 📋 Índice

1. [Requisitos](#requisitos)
2. [Passo 1: Preparar Hospedagem](#passo-1-preparar-hospedagem)
3. [Passo 2: Upload dos Arquivos](#passo-2-upload-dos-arquivos)
4. [Passo 3: Instalação Automática](#passo-3-instalação-automática)
5. [Passo 4: Configuração Manual (Alternativa)](#passo-4-configuração-manual-alternativa)
6. [Passo 5: Configurações Adicionais](#passo-5-configurações-adicionais)
7. [Troubleshooting](#troubleshooting)

---

## ✅ Requisitos

- **PHP**: 7.4 ou superior
- **MySQL**: 5.7 ou superior
- **Espaço em disco**: Mínimo 100MB
- **Acesso ao cPanel**: Para gerenciar banco de dados
- **Domínio**: jtisuporte.com.br (já configurado)

---

## 🚀 Passo 1: Preparar Hospedagem

### 1.1 Acessar cPanel

1. Abra seu navegador e acesse: **https://jtisuporte.com.br:2083**
2. Faça login com suas credenciais
3. Você verá o painel principal do cPanel

### 1.2 Criar Banco de Dados (Opcional - Automático)

Se preferir, o script de instalação cria automaticamente. Mas você pode fazer manualmente:

1. No cPanel, procure por **"MySQL Databases"** ou **"Banco de Dados MySQL"**
2. Clique em **"Create New Database"**
3. Digite o nome: `financemanager`
4. Clique em **"Create Database"**

### 1.3 Criar Usuário de Banco de Dados (Opcional)

1. Em **"MySQL Databases"**, vá para **"MySQL Users"**
2. Clique em **"Create New User"**
3. Digite:
   - **Username**: `financemanager` (ou seu usuário)
   - **Password**: Digite uma senha forte
4. Clique em **"Create User"**

### 1.4 Associar Usuário ao Banco

1. Em **"MySQL Users"**, procure por **"Add User to Database"**
2. Selecione o usuário e banco criados
3. Clique em **"Add"**
4. Marque **"All Privileges"** e clique em **"Make Changes"**

---

## 📤 Passo 2: Upload dos Arquivos

### 2.1 Acessar File Manager

1. No cPanel, procure por **"File Manager"**
2. Clique em **"Web Root"** ou **"public_html"**
3. Você verá a pasta raiz do seu domínio

### 2.2 Upload do Arquivo ZIP

**Opção A: Upload via File Manager**

1. Clique em **"Upload"** (ícone de seta para cima)
2. Selecione o arquivo `financemanager.zip`
3. Espere o upload completar
4. Clique com botão direito no ZIP → **"Extract"**
5. Escolha extrair na pasta raiz
6. Delete o arquivo ZIP após extrair

**Opção B: Upload via FTP**

1. Use um cliente FTP (FileZilla, WinSCP)
2. Conecte com suas credenciais FTP
3. Navegue até **public_html**
4. Faça upload da pasta `financemanager`
5. Extraia se necessário

### 2.3 Estrutura de Pastas

Após o upload, você deve ter:

```
public_html/
├── financemanager/
│   ├── public/
│   ├── src/
│   ├── database/
│   ├── config/
│   ├── .env
│   ├── install.php
│   └── ... (outros arquivos)
```

---

## ⚙️ Passo 3: Instalação Automática

### 3.1 Acessar Script de Instalação

1. Abra seu navegador
2. Acesse: **https://jtisuporte.com.br/financemanager/install.php**
3. Você verá a tela de instalação

### 3.2 Preencher Formulário

**Passo 1: Configuração do Banco**

| Campo | Valor | Observação |
|-------|-------|-----------|
| URL da Aplicação | https://jtisuporte.com.br | Seu domínio |
| Host do Banco | localhost | Padrão em cPanel |
| Porta do Banco | 3306 | Padrão MySQL |
| Nome do Banco | financemanager | Criado no Passo 1 |
| Usuário do Banco | financemanager | Criado no Passo 1 |
| Senha do Banco | Sua senha | Criada no Passo 1 |

3. Clique em **"Continuar →"**

### 3.3 Criar Banco de Dados

1. Revise as informações
2. Clique em **"Instalar →"**
3. Aguarde a instalação (pode levar alguns segundos)
4. Você verá mensagens de sucesso

### 3.4 Finalizar Instalação

1. Após sucesso, delete o arquivo `install.php`:
   - Via File Manager: Clique direito → Delete
   - Via FTP: Delete o arquivo

2. Acesse: **https://jtisuporte.com.br/financemanager/**

3. Clique em **"Registrar"** para criar sua conta

---

## 🔧 Passo 4: Configuração Manual (Alternativa)

Se preferir configurar manualmente, siga estes passos:

### 4.1 Editar Arquivo .env

1. No File Manager, navegue até: `financemanager/`
2. Procure pelo arquivo `.env`
3. Clique com botão direito → **"Edit"**
4. Você verá um editor de texto

### 4.2 Alterar Dados do Banco de Dados

Procure pelas linhas:

```ini
DB_HOST=localhost
DB_PORT=3306
DB_NAME=financemanager
DB_USER=seu_usuario
DB_PASSWORD=sua_senha
```

**Altere para seus dados:**

```ini
DB_HOST=localhost
DB_PORT=3306
DB_NAME=financemanager
DB_USER=financemanager
DB_PASSWORD=sua_senha_aqui
```

### 4.3 Alterar URL da Aplicação

Procure pela linha:

```ini
APP_URL=http://localhost/financemanager
```

**Altere para:**

```ini
APP_URL=https://jtisuporte.com.br/financemanager
```

### 4.4 Salvar Arquivo

1. Clique em **"Save"** (Ctrl+S)
2. Feche o editor

### 4.5 Importar Banco de Dados

1. No cPanel, procure por **"phpMyAdmin"**
2. Faça login com suas credenciais MySQL
3. Selecione o banco **"financemanager"**
4. Clique em **"Import"**
5. Clique em **"Choose File"** e selecione: `financemanager/database/schema.sql`
6. Clique em **"Import"**
7. Aguarde a importação completar

---

## 🔐 Passo 5: Configurações Adicionais

### 5.1 Ativar mod_rewrite (Importante!)

1. No cPanel, procure por **"Apache Handlers"** ou **"Select PHP Version"**
2. Clique em **"PHP Version"** (ou "Select PHP Version")
3. Procure por **"mod_rewrite"** na lista
4. Certifique-se de que está **habilitado** ✅
5. Salve as alterações

### 5.2 Configurar SSL (HTTPS)

1. No cPanel, procure por **"AutoSSL"** ou **"SSL/TLS"**
2. Clique em **"Manage SSL Sites"**
3. Procure por `jtisuporte.com.br`
4. Clique em **"Install"** se não estiver instalado
5. Aguarde a instalação (pode levar alguns minutos)

### 5.3 Configurar Permissões de Pasta

1. No File Manager, navegue até: `financemanager/`
2. Clique com botão direito em cada pasta:
   - `logs/`
   - `uploads/`
   - `tmp/`
3. Clique em **"Change Permissions"**
4. Altere para: **755** ou **777**
5. Clique em **"Change"**

### 5.4 Configurar OAuth (Google) - Opcional

Se deseja login com Google:

1. Acesse: https://console.cloud.google.com
2. Crie um novo projeto
3. Ative a API Google+
4. Crie credenciais OAuth 2.0
5. Configure URIs autorizados:
   - `https://jtisuporte.com.br/financemanager/auth/google/callback`
6. Copie o Client ID e Secret
7. Edite o arquivo `.env`:

```ini
GOOGLE_CLIENT_ID=seu-client-id
GOOGLE_CLIENT_SECRET=seu-client-secret
```

8. Salve o arquivo

---

## 🎯 Primeiro Acesso

1. Abra: **https://jtisuporte.com.br/financemanager/**
2. Clique em **"Registrar"**
3. Preencha:
   - Nome
   - Email
   - Senha (mínimo 8 caracteres)
4. Clique em **"Criar Conta"**
5. Você será redirecionado para o Dashboard

---

## 🆘 Troubleshooting

### Erro: "Conexão com banco de dados recusada"

**Solução:**
1. Verifique as credenciais em `.env`
2. Certifique-se de que o banco de dados foi criado
3. Verifique se o usuário tem permissões corretas
4. Teste a conexão no phpMyAdmin

### Erro: "Página não encontrada (404)"

**Solução:**
1. Verifique se `mod_rewrite` está ativado
2. Verifique se o arquivo `.htaccess` existe em `public/`
3. Reinicie o Apache no cPanel

### Erro: "Permissão negada ao salvar arquivo"

**Solução:**
1. Altere permissões das pastas para **755** ou **777**
2. Verifique se o proprietário é `www-data` ou seu usuário
3. Contate seu provedor de hospedagem

### Erro: "Arquivo .env não encontrado"

**Solução:**
1. Copie `.env.example` para `.env`
2. Edite com suas configurações
3. Salve o arquivo

### Erro: "SSL/HTTPS não funciona"

**Solução:**
1. Ative SSL no cPanel
2. Aguarde a propagação do DNS (até 24 horas)
3. Limpe o cache do navegador
4. Tente em modo anônimo

---

## 📞 Suporte

Se encontrar problemas:

1. **Verifique os logs**: `financemanager/logs/`
2. **Consulte a documentação**: `financemanager/README.md`
3. **Teste a API**: `https://jtisuporte.com.br/financemanager/api/`
4. **Contate seu provedor**: Para problemas de servidor

---

## ✨ Parabéns!

Sua aplicação Finance Manager está instalada e funcionando! 🎉

**Próximas ações sugeridas:**

1. ✅ Delete o arquivo `install.php`
2. ✅ Configure backups automáticos
3. ✅ Configure OAuth (Google/Apple)
4. ✅ Configure Open Banking
5. ✅ Crie sua primeira transação

---

**Versão**: 1.0.0  
**Última atualização**: Janeiro 2024  
**Status**: Pronto para Produção
