# Guia de Instalação - Finance Manager

## Requisitos do Sistema

- **PHP**: 7.4 ou superior
- **MySQL**: 5.7 ou superior (ou MariaDB 10.3+)
- **Apache**: 2.4 ou superior com mod_rewrite ativado
- **Composer**: Para gerenciamento de dependências
- **Node.js**: (Opcional) Para ferramentas de desenvolvimento

## Passo 1: Preparar o Servidor

### 1.1 Ativar mod_rewrite no Apache

```bash
sudo a2enmod rewrite
sudo systemctl restart apache2
```

### 1.2 Criar diretório do projeto

```bash
mkdir -p /home/ubuntu/financemanager
cd /home/ubuntu/financemanager
```

## Passo 2: Configurar Banco de Dados

### 2.1 Criar banco de dados

```bash
mysql -u root -p
```

```sql
CREATE DATABASE financemanager CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
CREATE USER 'financemanager'@'localhost' IDENTIFIED BY 'sua_senha_segura';
GRANT ALL PRIVILEGES ON financemanager.* TO 'financemanager'@'localhost';
FLUSH PRIVILEGES;
EXIT;
```

### 2.2 Importar schema

```bash
mysql -u financemanager -p financemanager < database/schema.sql
```

## Passo 3: Configurar Aplicação

### 3.1 Copiar arquivo de configuração

```bash
cp .env.example .env
```

### 3.2 Editar arquivo .env

```bash
nano .env
```

Configure as seguintes variáveis:

```env
DB_HOST=localhost
DB_NAME=financemanager
DB_USER=financemanager
DB_PASSWORD=sua_senha_segura

APP_URL=https://seu-dominio.com
APP_ENV=production
APP_DEBUG=false

GOOGLE_CLIENT_ID=seu-client-id
GOOGLE_CLIENT_SECRET=seu-client-secret

OPEN_BANKING_API_KEY=sua-api-key
```

### 3.3 Instalar dependências PHP

```bash
composer install
```

## Passo 4: Configurar Permissões

```bash
# Permissões para diretórios
chmod 755 /home/ubuntu/financemanager
chmod 755 /home/ubuntu/financemanager/public
chmod 755 /home/ubuntu/financemanager/src

# Permissões para arquivos
chmod 644 /home/ubuntu/financemanager/public/index.php
chmod 644 /home/ubuntu/financemanager/public/api.php

# Permissões para diretórios de escrita
chmod 777 /home/ubuntu/financemanager/logs
chmod 777 /home/ubuntu/financemanager/uploads
chmod 777 /home/ubuntu/financemanager/tmp

# Proprietário
chown -R www-data:www-data /home/ubuntu/financemanager
```

## Passo 5: Configurar Virtual Host no Apache

### 5.1 Criar arquivo de configuração

```bash
sudo nano /etc/apache2/sites-available/financemanager.conf
```

### 5.2 Adicionar configuração

```apache
<VirtualHost *:80>
    ServerName seu-dominio.com
    ServerAlias www.seu-dominio.com
    
    DocumentRoot /home/ubuntu/financemanager/public
    
    <Directory /home/ubuntu/financemanager/public>
        Options Indexes FollowSymLinks
        AllowOverride All
        Require all granted
        
        # Rewrite rules
        <IfModule mod_rewrite.c>
            RewriteEngine On
            RewriteBase /
            RewriteCond %{REQUEST_FILENAME} !-f
            RewriteCond %{REQUEST_FILENAME} !-d
            RewriteRule ^(.*)$ index.php?path=$1 [QSA,L]
        </IfModule>
    </Directory>
    
    # Logs
    ErrorLog ${APACHE_LOG_DIR}/financemanager-error.log
    CustomLog ${APACHE_LOG_DIR}/financemanager-access.log combined
    
    # SSL (recomendado)
    # SSLEngine on
    # SSLCertificateFile /etc/letsencrypt/live/seu-dominio.com/fullchain.pem
    # SSLCertificateKeyFile /etc/letsencrypt/live/seu-dominio.com/privkey.pem
</VirtualHost>
```

### 5.3 Ativar site

```bash
sudo a2ensite financemanager.conf
sudo systemctl reload apache2
```

## Passo 6: Configurar SSL (Let's Encrypt)

```bash
sudo apt-get install certbot python3-certbot-apache
sudo certbot certonly --apache -d seu-dominio.com -d www.seu-dominio.com
```

## Passo 7: Configurar OAuth (Google e Apple)

### 7.1 Google OAuth

1. Acesse [Google Cloud Console](https://console.cloud.google.com)
2. Crie um novo projeto
3. Ative a API Google+
4. Crie credenciais (OAuth 2.0 Client ID)
5. Configure URIs autorizados:
   - `https://seu-dominio.com/auth/google/callback`
6. Copie Client ID e Secret para `.env`

### 7.2 Apple OAuth

1. Acesse [Apple Developer](https://developer.apple.com)
2. Crie um App ID
3. Ative "Sign in with Apple"
4. Crie uma chave privada
5. Configure URLs de retorno:
   - `https://seu-dominio.com/auth/apple/callback`
6. Copie as credenciais para `.env`

## Passo 8: Configurar Open Banking

### 8.1 Registrar na plataforma de Open Banking

1. Acesse a plataforma de Open Banking desejada
2. Registre sua aplicação
3. Obtenha as credenciais de API
4. Configure em `.env`:
   - `OPEN_BANKING_API_KEY`
   - `OPEN_BANKING_API_URL`
   - `OPEN_BANKING_CLIENT_ID`

## Passo 9: Testar Instalação

### 9.1 Verificar acesso

Acesse `https://seu-dominio.com` no navegador

### 9.2 Criar primeira conta

1. Clique em "Registrar"
2. Use email, Google ou Apple
3. Complete o cadastro

### 9.3 Testar funcionalidades

- Dashboard
- Adicionar transações
- Criar contas
- Conectar banco (Open Banking)
- Gerar relatórios

## Troubleshooting

### Erro 404 em rotas

Verifique se `mod_rewrite` está ativado:
```bash
sudo a2enmod rewrite
sudo systemctl restart apache2
```

### Erro de permissão de arquivo

```bash
chmod 777 /home/ubuntu/financemanager/logs
chmod 777 /home/ubuntu/financemanager/uploads
chmod 777 /home/ubuntu/financemanager/tmp
```

### Erro de conexão com banco de dados

Verifique credenciais em `.env` e se o MySQL está rodando:
```bash
sudo systemctl status mysql
```

### Erro de OAuth

Verifique se as URLs de retorno estão corretas no console de cada provedor.

## Manutenção

### Backup do banco de dados

```bash
mysqldump -u financemanager -p financemanager > backup_$(date +%Y%m%d).sql
```

### Atualizar aplicação

```bash
cd /home/ubuntu/financemanager
git pull origin main
composer install
php database/migrate.php
```

### Limpar logs

```bash
rm /home/ubuntu/financemanager/logs/*.log
```

## Suporte

Para mais informações, consulte a documentação completa em `/home/ubuntu/financemanager/README.md`
