# ⚡ Guia Rápido de Configuração

## 🎯 Alterações Necessárias

Existem **3 formas** de configurar o Finance Manager:

---

## ✅ Opção 1: Instalação Automática (RECOMENDADO)

### Acesse:
```
https://jtisuporte.com.br/financemanager/install.php
```

### Preencha o formulário com:
- **URL**: https://jtisuporte.com.br/financemanager
- **Host**: localhost
- **Porta**: 3306
- **Banco**: financemanager
- **Usuário**: (seu usuário MySQL)
- **Senha**: (sua senha MySQL)

### Clique em "Instalar"

✅ **Pronto! Tudo será configurado automaticamente.**

---

## 🔧 Opção 2: Configuração Manual via .env

### Arquivo a editar:
```
financemanager/.env
```

### Localize e altere:

#### 1️⃣ Banco de Dados

**Procure por:**
```ini
DB_HOST=localhost
DB_PORT=3306
DB_NAME=financemanager
DB_USER=seu_usuario
DB_PASSWORD=sua_senha
```

**Altere para seus dados:**
```ini
DB_HOST=localhost
DB_PORT=3306
DB_NAME=financemanager
DB_USER=financemanager
DB_PASSWORD=sua_senha_aqui
```

#### 2️⃣ URL da Aplicação

**Procure por:**
```ini
APP_URL=http://localhost/financemanager
```

**Altere para:**
```ini
APP_URL=https://jtisuporte.com.br/financemanager
```

#### 3️⃣ Ambiente

**Procure por:**
```ini
APP_ENV=development
APP_DEBUG=true
```

**Altere para:**
```ini
APP_ENV=production
APP_DEBUG=false
```

### Salve o arquivo (Ctrl+S)

✅ **Pronto!**

---

## 📊 Opção 3: Configuração Manual via phpMyAdmin

### Passo 1: Importar Banco de Dados

1. Acesse phpMyAdmin no cPanel
2. Clique em **"Novo"** ou **"Create"**
3. Digite: `financemanager`
4. Clique em **"Criar"**

### Passo 2: Importar Schema

1. Selecione o banco `financemanager`
2. Clique em **"Importar"**
3. Selecione o arquivo: `financemanager/database/schema.sql`
4. Clique em **"Executar"**

### Passo 3: Editar .env

1. File Manager → `financemanager/`
2. Clique direito em `.env` → **"Edit"**
3. Altere as credenciais (veja Opção 2)
4. Salve (Ctrl+S)

✅ **Pronto!**

---

## 📝 Arquivos Importantes

### Arquivo Principal de Configuração:
```
financemanager/.env
```

**Seções principais:**

| Seção | Variáveis | Descrição |
|-------|-----------|-----------|
| **Banco de Dados** | DB_HOST, DB_USER, DB_PASSWORD, DB_NAME | Credenciais MySQL |
| **Aplicação** | APP_URL, APP_ENV, APP_DEBUG | Configurações gerais |
| **Segurança** | SESSION_SECRET, CSRF_TOKEN_EXPIRY | Tokens e sessões |
| **OAuth** | GOOGLE_CLIENT_ID, APPLE_CLIENT_ID | Login social |
| **Open Banking** | OPEN_BANKING_API_KEY | Integração com bancos |

---

## 🔍 Onde Encontrar Credenciais no cPanel

### 1. Usuário e Senha do Banco de Dados

**Caminho no cPanel:**
```
Home → MySQL Databases → MySQL Users
```

**Você verá:**
- Username (ex: jtisuporte_financemanager)
- Password (criada por você)

### 2. Nome do Banco de Dados

**Caminho no cPanel:**
```
Home → MySQL Databases
```

**Você verá:**
- Database name (ex: jtisuporte_financemanager)

### 3. Host do Banco

**Padrão**: `localhost`

Se não funcionar, tente:
- `127.0.0.1`
- Seu IP do servidor

---

## ✨ Verificação Final

Após configurar, verifique:

### 1. Acesse a aplicação:
```
https://jtisuporte.com.br/financemanager/
```

### 2. Você deve ver:
- ✅ Página de login/registro
- ✅ Sem erros de conexão
- ✅ HTTPS funcionando (cadeado verde)

### 3. Teste o registro:
- Clique em "Registrar"
- Preencha os dados
- Clique em "Criar Conta"
- Você deve ser redirecionado para o Dashboard

---

## 🚨 Erros Comuns

| Erro | Solução |
|------|---------|
| "Conexão recusada" | Verifique credenciais em `.env` |
| "Página não encontrada" | Ative `mod_rewrite` no cPanel |
| "Permissão negada" | Altere permissões de pastas para 755 |
| "SSL não funciona" | Ative SSL no cPanel e aguarde propagação |

---

## 🎓 Dicas Importantes

1. **Sempre use HTTPS** (https://, não http://)
2. **Altere APP_DEBUG para false** em produção
3. **Delete install.php** após instalação
4. **Faça backups regulares** do banco de dados
5. **Guarde suas credenciais** em local seguro

---

## 📞 Precisa de Ajuda?

1. Consulte: `MANUAL_INSTALACAO_CPANEL.md`
2. Verifique logs: `financemanager/logs/`
3. Teste API: `https://jtisuporte.com.br/financemanager/api/`
4. Contate seu provedor de hospedagem

---

**Última atualização**: Janeiro 2024  
**Status**: Pronto para Produção
