# ✅ Checklist de Instalação - Finance Manager

Use este checklist para garantir que todos os passos foram executados corretamente.

---

## 📋 Pré-Instalação

- [ ] Tenho acesso ao cPanel
- [ ] Tenho as credenciais de login do cPanel
- [ ] Meu domínio está apontando para o servidor (jtisuporte.com.br)
- [ ] Baixei o arquivo `financemanager-completo.zip`

---

## 🗄️ Banco de Dados

- [ ] Acessei MySQL Databases no cPanel
- [ ] Criei o banco de dados: `financemanager`
- [ ] Criei o usuário: `financemanager`
- [ ] Anotei a senha do usuário em local seguro
- [ ] Associei o usuário ao banco de dados
- [ ] Concedi ALL PRIVILEGES ao usuário

**Credenciais anotadas:**
```
Host: localhost
Porta: 3306
Banco: financemanager
Usuário: financemanager
Senha: _____________________ (anote aqui)
```

---

## 📤 Upload de Arquivos

- [ ] Acessei File Manager no cPanel
- [ ] Naveguei até `public_html`
- [ ] Fiz upload do arquivo `financemanager-completo.zip`
- [ ] Extraí o arquivo ZIP
- [ ] Verifiquei que a pasta `financemanager` foi criada
- [ ] Deletei o arquivo ZIP após extração

**Estrutura verificada:**
```
public_html/
└── financemanager/
    ├── public/
    ├── src/
    ├── database/
    ├── config/
    ├── .env
    └── install.php
```

---

## ⚙️ Instalação Automática

- [ ] Acessei: `https://jtisuporte.com.br/financemanager/install.php`
- [ ] Preenchi o formulário com as credenciais do banco
- [ ] Cliquei em "Continuar"
- [ ] Cliquei em "Instalar"
- [ ] Vi mensagem de sucesso
- [ ] Deletei o arquivo `install.php` após instalação

**OU**

## 🔧 Configuração Manual

- [ ] Editei o arquivo `.env`
- [ ] Alterei `DB_USER` para meu usuário
- [ ] Alterei `DB_PASSWORD` para minha senha
- [ ] Alterei `APP_URL` para `https://jtisuporte.com.br/financemanager`
- [ ] Alterei `APP_ENV` para `production`
- [ ] Alterei `APP_DEBUG` para `false`
- [ ] Salvei o arquivo `.env`
- [ ] Acessei phpMyAdmin
- [ ] Importei o arquivo `database/schema.sql`
- [ ] Verifiquei que 14 tabelas foram criadas

---

## 🔐 Configurações de Segurança

- [ ] Ativei `mod_rewrite` no Apache
- [ ] Configurei SSL/HTTPS no cPanel
- [ ] Verifiquei que o cadeado verde aparece no navegador
- [ ] Alterei permissões da pasta `logs/` para 755
- [ ] Alterei permissões da pasta `uploads/` para 755
- [ ] Alterei permissões da pasta `tmp/` para 755
- [ ] Deletei o arquivo `install.php`

---

## ✨ Primeiro Acesso

- [ ] Acessei: `https://jtisuporte.com.br/financemanager/`
- [ ] Vi a página de login/registro
- [ ] Não vi erros de conexão
- [ ] Cliquei em "Registrar"
- [ ] Criei minha conta com:
  - Nome: _____________________
  - Email: _____________________
  - Senha: _____________________
- [ ] Fui redirecionado para o Dashboard
- [ ] Vi os cards de estatísticas
- [ ] Vi os botões "Ganhei Dinheiro" e "Gastei Dinheiro"

---

## 🎯 Testes Funcionais

- [ ] Cliquei em "Ganhei Dinheiro"
- [ ] Adicionei uma receita de teste
- [ ] Vi a receita aparecer no Dashboard
- [ ] Cliquei em "Gastei Dinheiro"
- [ ] Adicionei uma despesa de teste
- [ ] Vi a despesa aparecer no Dashboard
- [ ] Verifiquei que o saldo foi atualizado
- [ ] Acessei "Contas" no menu
- [ ] Criei uma conta bancária
- [ ] Acessei "Categorias" no menu
- [ ] Vi as categorias padrão
- [ ] Acessei "Relatórios" no menu
- [ ] Gerei um relatório
- [ ] Exportei o relatório em PDF

---

## 🔗 Configurações Opcionais

### Google OAuth (Opcional)

- [ ] Acessei Google Cloud Console
- [ ] Criei um projeto
- [ ] Ativei Google+ API
- [ ] Criei credenciais OAuth 2.0
- [ ] Configurei URI de redirecionamento: `https://jtisuporte.com.br/financemanager/auth/google/callback`
- [ ] Copiei Client ID e Secret
- [ ] Editei `.env` e adicionei:
  ```
  GOOGLE_CLIENT_ID=seu-client-id
  GOOGLE_CLIENT_SECRET=seu-client-secret
  ```
- [ ] Testei login com Google

### Apple OAuth (Opcional)

- [ ] Acessei Apple Developer
- [ ] Criei um App ID
- [ ] Ativei "Sign in with Apple"
- [ ] Criei uma chave privada
- [ ] Configurei URL de retorno: `https://jtisuporte.com.br/financemanager/auth/apple/callback`
- [ ] Copiei as credenciais
- [ ] Editei `.env` e adicionei as credenciais Apple
- [ ] Testei login com Apple

### Open Banking (Opcional)

- [ ] Registrei na plataforma de Open Banking
- [ ] Obtive API Key
- [ ] Editei `.env` e adicionei:
  ```
  OPEN_BANKING_API_KEY=sua-api-key
  OPEN_BANKING_API_URL=url-da-api
  ```
- [ ] Testei conexão com banco

---

## 🛡️ Segurança Final

- [ ] Arquivo `install.php` foi deletado
- [ ] Arquivo `.env` tem permissões corretas (644)
- [ ] SSL/HTTPS está funcionando
- [ ] `APP_DEBUG` está como `false`
- [ ] `APP_ENV` está como `production`
- [ ] Senha do banco de dados é forte
- [ ] Credenciais estão guardadas em local seguro

---

## 📊 Backup

- [ ] Configurei backup automático do banco de dados no cPanel
- [ ] Testei o backup manual
- [ ] Anotei o local dos backups
- [ ] Configurei backup dos arquivos

---

## 📞 Suporte

Se algum item não foi marcado ou apresentou erro:

1. Consulte: `MANUAL_INSTALACAO_CPANEL.md`
2. Consulte: `MANUAL_VISUAL_INSTALACAO.md`
3. Consulte: `GUIA_RAPIDO_CONFIGURACAO.md`
4. Verifique os logs em: `financemanager/logs/`
5. Contate seu provedor de hospedagem

---

## ✅ Instalação Completa

Se todos os itens foram marcados:

**🎉 Parabéns! Sua instalação está completa e funcional!**

**Próximos passos:**
1. Explore todas as funcionalidades
2. Configure suas contas bancárias
3. Adicione suas transações
4. Configure categorias personalizadas
5. Crie tags para organizar
6. Gere relatórios mensais
7. Configure Open Banking (se disponível)

---

**Data da instalação**: ___/___/______  
**Versão instalada**: 1.0.0  
**Domínio**: jtisuporte.com.br  
**Status**: ✅ Pronto para Produção

---

## 📝 Notas Adicionais

Use este espaço para anotar observações durante a instalação:

```
_____________________________________________________________

_____________________________________________________________

_____________________________________________________________

_____________________________________________________________

_____________________________________________________________
```

---

**Última atualização**: Janeiro 2024
